@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTlsCipherPolicies.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property includeListener
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property policies
 * @property status
 * @property tlsCipherPolicyName
 */
public data class GetTlsCipherPoliciesResult(
    public val id: String,
    public val ids: List<String>,
    public val includeListener: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val policies: List<GetTlsCipherPoliciesPolicy>,
    public val status: String? = null,
    public val tlsCipherPolicyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetTlsCipherPoliciesResult): GetTlsCipherPoliciesResult = GetTlsCipherPoliciesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeListener = javaType.includeListener().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.slb.kotlin.outputs.GetTlsCipherPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tlsCipherPolicyName = javaType.tlsCipherPolicyName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
