@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZones.
 * @property availableSlbAddressIpVersion
 * @property availableSlbAddressType
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of primary zone IDs.
 * @property masterZoneId (Available in 1.157.0+) The primary zone.
 * @property outputFile
 * @property slaveZoneId (Available in 1.157.0+) The secondary zone.
 * @property zones A list of availability zones. Each element contains the following attributes:
 */
public data class GetZonesResult(
    public val availableSlbAddressIpVersion: String? = null,
    public val availableSlbAddressType: String? = null,
    @Deprecated(
        message = """
  The parameter enable_details has been deprecated from version v1.154.0+
  """,
    )
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val masterZoneId: String? = null,
    public val outputFile: String? = null,
    public val slaveZoneId: String? = null,
    public val zones: List<GetZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetZonesResult): GetZonesResult =
            GetZonesResult(
                availableSlbAddressIpVersion = javaType.availableSlbAddressIpVersion().map({ args0 ->
                    args0
                }).orElse(null),
                availableSlbAddressType = javaType.availableSlbAddressType().map({ args0 -> args0 }).orElse(null),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                masterZoneId = javaType.masterZoneId().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                slaveZoneId = javaType.slaveZoneId().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.slb.kotlin.outputs.GetZonesZone.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
