@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id ID of the zone. It is same as `master_zone_id`.
 * @property masterZoneId The primary zone.
 * @property slaveZoneId The secondary zone.
 * @property slbSlaveZoneIds (Deprecated from 1.157.0) A list of slb slave zone ids in which the slb master zone.
 * It has been deprecated from v1.157.0 and use `slave_zone_id` instead.
 * @property supportedResources (Available in 1.154.0+)A list of available resource which the slb master zone supported.
 */
public data class GetZonesZone(
    public val id: String,
    public val masterZoneId: String,
    public val slaveZoneId: String,
    @Deprecated(
        message = """
  the attribute slb_slave_zone_ids has been deprecated from version 1.157.0 and use slave_zone_id
      instead.
  """,
    )
    public val slbSlaveZoneIds: List<String>,
    public val supportedResources: List<GetZonesZoneSupportedResource>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.GetZonesZone): GetZonesZone =
            GetZonesZone(
                id = javaType.id(),
                masterZoneId = javaType.masterZoneId(),
                slaveZoneId = javaType.slaveZoneId(),
                slbSlaveZoneIds = javaType.slbSlaveZoneIds().map({ args0 -> args0 }),
                supportedResources = javaType.supportedResources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.slb.kotlin.outputs.GetZonesZoneSupportedResource.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
