@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property retriveClientIp Whether to retrieve the client ip.
 * @property retriveSlbId Indicates whether the SLB-ID header is used to retrieve the ID of the CLB instance. Default value: `false`. Valid values: `true`, `false`.
 * @property retriveSlbIp Indicates whether the SLB-IP header is used to retrieve the virtual IP address (VIP) requested by the client. Default value: `false`. Valid values: `true`, `false`.
 * @property retriveSlbProto Specifies whether to use the X-Forwarded-Proto header to retrieve the listener protocol. Default value: `false`. Valid values: `true`, `false`.
 */
public data class ListenerXForwardedFor(
    public val retriveClientIp: Boolean? = null,
    public val retriveSlbId: Boolean? = null,
    public val retriveSlbIp: Boolean? = null,
    public val retriveSlbProto: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.ListenerXForwardedFor): ListenerXForwardedFor = ListenerXForwardedFor(
            retriveClientIp = javaType.retriveClientIp().map({ args0 -> args0 }).orElse(null),
            retriveSlbId = javaType.retriveSlbId().map({ args0 -> args0 }).orElse(null),
            retriveSlbIp = javaType.retriveSlbIp().map({ args0 -> args0 }).orElse(null),
            retriveSlbProto = javaType.retriveSlbProto().map({ args0 -> args0 }).orElse(null),
        )
    }
}
