@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.slb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property port The port used by the backend server. Valid values: `1` to `65535`.
 * @property serverIds The list of Elastic Compute Service (ECS) Ids or Elastic Network Interface (ENI) Ids.
 * @property type Specify the type of the backend server. Default value: `ecs`. Valid values: `ecs`, `eni`.
 * @property weight Weight of the backend server. Default value: `100`. Valid values: `0` to `100`.
 */
public data class ServerGroupServer(
    public val port: Int,
    public val serverIds: List<String>,
    public val type: String? = null,
    public val weight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.slb.outputs.ServerGroupServer): ServerGroupServer = ServerGroupServer(
            port = javaType.port(),
            serverIds = javaType.serverIds().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
