@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationAnnotationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Field name.
 * @property value Field value.
 */
public data class AlertConfigurationAnnotationArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationAnnotationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationAnnotationArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationAnnotationArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationAnnotationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationAnnotationArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Field name.
     */
    @JvmName("ftmxkgyfcbogksft")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Field value.
     */
    @JvmName("pqffrkwyxbcomdfk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Field name.
     */
    @JvmName("jcninjmqlhwogujp")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Field value.
     */
    @JvmName("iqebxxfndjbjniao")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlertConfigurationAnnotationArgs = AlertConfigurationAnnotationArgs(
        key = key,
        `value` = `value`,
    )
}
