@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property annotations Template Annotations.
 * @property autoAnnotation Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
 * @property conditionConfiguration Alarm trigger condition. See `condition_configuration` below.
 * @property dashboard The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
 * @property groupConfiguration Group evaluation configuration. See `group_configuration` below.
 * @property joinConfigurations Set operation configuration. See `join_configurations` below.
 * @property labels Label. See `labels` below.
 * @property muteUntil Second-level timestamp representing the temporary shutdown deadline.
 * @property noDataFire Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
 * @property noDataSeverity Alarm severity when no data triggers an alarm.
 * @property policyConfiguration Alert policy configuration. See `policy_configuration` below.
 * @property queryLists Query the statistical list. See `query_list` below.
 * @property sendResolved Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
 * @property severityConfigurations Trigger condition, set at least one trigger condition. See `severity_configurations` below.
 * @property sinkAlerthub Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
 * @property sinkCms Configure alerts sent to CloudMonitor. See `sink_cms` below.
 * @property sinkEventStore Configuration of sending alarms to EventStore. See `sink_event_store` below.
 * @property tags Customize the category of alarm monitoring rules.
 * @property templateConfiguration Alarm rule template configuration. See `template_configuration` below.
 * @property threshold Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
 * @property type Template Type.
 * @property version Template Version.
 */
public data class AlertConfigurationArgs(
    public val annotations: Output<List<AlertConfigurationAnnotationArgs>>? = null,
    public val autoAnnotation: Output<Boolean>? = null,
    public val conditionConfiguration: Output<AlertConfigurationConditionConfigurationArgs>? = null,
    public val dashboard: Output<String>? = null,
    public val groupConfiguration: Output<AlertConfigurationGroupConfigurationArgs>? = null,
    public val joinConfigurations: Output<List<AlertConfigurationJoinConfigurationArgs>>? = null,
    public val labels: Output<List<AlertConfigurationLabelArgs>>? = null,
    public val muteUntil: Output<Int>? = null,
    public val noDataFire: Output<Boolean>? = null,
    public val noDataSeverity: Output<Int>? = null,
    public val policyConfiguration: Output<AlertConfigurationPolicyConfigurationArgs>? = null,
    public val queryLists: Output<List<AlertConfigurationQueryListArgs>>? = null,
    public val sendResolved: Output<Boolean>? = null,
    public val severityConfigurations: Output<List<AlertConfigurationSeverityConfigurationArgs>>? =
        null,
    public val sinkAlerthub: Output<AlertConfigurationSinkAlerthubArgs>? = null,
    public val sinkCms: Output<AlertConfigurationSinkCmsArgs>? = null,
    public val sinkEventStore: Output<AlertConfigurationSinkEventStoreArgs>? = null,
    public val tags: Output<List<String>>? = null,
    public val templateConfiguration: Output<AlertConfigurationTemplateConfigurationArgs>? = null,
    public val threshold: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationArgs.builder()
            .annotations(
                annotations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoAnnotation(autoAnnotation?.applyValue({ args0 -> args0 }))
            .conditionConfiguration(
                conditionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dashboard(dashboard?.applyValue({ args0 -> args0 }))
            .groupConfiguration(
                groupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .joinConfigurations(
                joinConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .muteUntil(muteUntil?.applyValue({ args0 -> args0 }))
            .noDataFire(noDataFire?.applyValue({ args0 -> args0 }))
            .noDataSeverity(noDataSeverity?.applyValue({ args0 -> args0 }))
            .policyConfiguration(
                policyConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .queryLists(
                queryLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sendResolved(sendResolved?.applyValue({ args0 -> args0 }))
            .severityConfigurations(
                severityConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sinkAlerthub(sinkAlerthub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sinkCms(sinkCms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sinkEventStore(sinkEventStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .templateConfiguration(
                templateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationArgsBuilder internal constructor() {
    private var annotations: Output<List<AlertConfigurationAnnotationArgs>>? = null

    private var autoAnnotation: Output<Boolean>? = null

    private var conditionConfiguration: Output<AlertConfigurationConditionConfigurationArgs>? = null

    private var dashboard: Output<String>? = null

    private var groupConfiguration: Output<AlertConfigurationGroupConfigurationArgs>? = null

    private var joinConfigurations: Output<List<AlertConfigurationJoinConfigurationArgs>>? = null

    private var labels: Output<List<AlertConfigurationLabelArgs>>? = null

    private var muteUntil: Output<Int>? = null

    private var noDataFire: Output<Boolean>? = null

    private var noDataSeverity: Output<Int>? = null

    private var policyConfiguration: Output<AlertConfigurationPolicyConfigurationArgs>? = null

    private var queryLists: Output<List<AlertConfigurationQueryListArgs>>? = null

    private var sendResolved: Output<Boolean>? = null

    private var severityConfigurations: Output<List<AlertConfigurationSeverityConfigurationArgs>>? =
        null

    private var sinkAlerthub: Output<AlertConfigurationSinkAlerthubArgs>? = null

    private var sinkCms: Output<AlertConfigurationSinkCmsArgs>? = null

    private var sinkEventStore: Output<AlertConfigurationSinkEventStoreArgs>? = null

    private var tags: Output<List<String>>? = null

    private var templateConfiguration: Output<AlertConfigurationTemplateConfigurationArgs>? = null

    private var threshold: Output<Int>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Template Annotations.
     */
    @JvmName("ltcdnamvigopfpxh")
    public suspend fun annotations(`value`: Output<List<AlertConfigurationAnnotationArgs>>) {
        this.annotations = value
    }

    @JvmName("upgqnrjtuvsdsogf")
    public suspend fun annotations(vararg values: Output<AlertConfigurationAnnotationArgs>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values Template Annotations.
     */
    @JvmName("ayklttlfhfabsndw")
    public suspend fun annotations(values: List<Output<AlertConfigurationAnnotationArgs>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
     */
    @JvmName("rsgneojubkfscjgn")
    public suspend fun autoAnnotation(`value`: Output<Boolean>) {
        this.autoAnnotation = value
    }

    /**
     * @param value Alarm trigger condition. See `condition_configuration` below.
     */
    @JvmName("syygttyhgbjulddx")
    public suspend fun conditionConfiguration(`value`: Output<AlertConfigurationConditionConfigurationArgs>) {
        this.conditionConfiguration = value
    }

    /**
     * @param value The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
     */
    @JvmName("obarngaqkhsrwgay")
    public suspend fun dashboard(`value`: Output<String>) {
        this.dashboard = value
    }

    /**
     * @param value Group evaluation configuration. See `group_configuration` below.
     */
    @JvmName("lyivgumlijgppepm")
    public suspend fun groupConfiguration(`value`: Output<AlertConfigurationGroupConfigurationArgs>) {
        this.groupConfiguration = value
    }

    /**
     * @param value Set operation configuration. See `join_configurations` below.
     */
    @JvmName("jdhbmfsmqcjkrurb")
    public suspend fun joinConfigurations(`value`: Output<List<AlertConfigurationJoinConfigurationArgs>>) {
        this.joinConfigurations = value
    }

    @JvmName("kdhljqrstwkaoxvo")
    public suspend fun joinConfigurations(vararg values: Output<AlertConfigurationJoinConfigurationArgs>) {
        this.joinConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Set operation configuration. See `join_configurations` below.
     */
    @JvmName("jskbfmuytpmxcyvk")
    public suspend fun joinConfigurations(values: List<Output<AlertConfigurationJoinConfigurationArgs>>) {
        this.joinConfigurations = Output.all(values)
    }

    /**
     * @param value Label. See `labels` below.
     */
    @JvmName("gmhjrpncimbrougd")
    public suspend fun labels(`value`: Output<List<AlertConfigurationLabelArgs>>) {
        this.labels = value
    }

    @JvmName("xrjffpalgykdmres")
    public suspend fun labels(vararg values: Output<AlertConfigurationLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values Label. See `labels` below.
     */
    @JvmName("mdubmuvsplpupwoj")
    public suspend fun labels(values: List<Output<AlertConfigurationLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Second-level timestamp representing the temporary shutdown deadline.
     */
    @JvmName("efademufdnqurfxd")
    public suspend fun muteUntil(`value`: Output<Int>) {
        this.muteUntil = value
    }

    /**
     * @param value Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
     */
    @JvmName("rxtgcfbwgthiywjb")
    public suspend fun noDataFire(`value`: Output<Boolean>) {
        this.noDataFire = value
    }

    /**
     * @param value Alarm severity when no data triggers an alarm.
     */
    @JvmName("cxegieuqkuymtsyi")
    public suspend fun noDataSeverity(`value`: Output<Int>) {
        this.noDataSeverity = value
    }

    /**
     * @param value Alert policy configuration. See `policy_configuration` below.
     */
    @JvmName("lnvpkkcsxqbeqamc")
    public suspend fun policyConfiguration(`value`: Output<AlertConfigurationPolicyConfigurationArgs>) {
        this.policyConfiguration = value
    }

    /**
     * @param value Query the statistical list. See `query_list` below.
     */
    @JvmName("wjghmwhfaxgtjwex")
    public suspend fun queryLists(`value`: Output<List<AlertConfigurationQueryListArgs>>) {
        this.queryLists = value
    }

    @JvmName("jrqtdsfyrulvbkob")
    public suspend fun queryLists(vararg values: Output<AlertConfigurationQueryListArgs>) {
        this.queryLists = Output.all(values.asList())
    }

    /**
     * @param values Query the statistical list. See `query_list` below.
     */
    @JvmName("mnfbgobldqogrvgx")
    public suspend fun queryLists(values: List<Output<AlertConfigurationQueryListArgs>>) {
        this.queryLists = Output.all(values)
    }

    /**
     * @param value Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
     */
    @JvmName("embueqmcwohhbdcs")
    public suspend fun sendResolved(`value`: Output<Boolean>) {
        this.sendResolved = value
    }

    /**
     * @param value Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("tblgsyhlwtstyjjq")
    public suspend fun severityConfigurations(`value`: Output<List<AlertConfigurationSeverityConfigurationArgs>>) {
        this.severityConfigurations = value
    }

    @JvmName("tofqxrisarqrdpuv")
    public suspend fun severityConfigurations(vararg values: Output<AlertConfigurationSeverityConfigurationArgs>) {
        this.severityConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("ggxbwmjvcgmpmlao")
    public suspend fun severityConfigurations(values: List<Output<AlertConfigurationSeverityConfigurationArgs>>) {
        this.severityConfigurations = Output.all(values)
    }

    /**
     * @param value Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
     */
    @JvmName("vvaprrnjkgjjgadu")
    public suspend fun sinkAlerthub(`value`: Output<AlertConfigurationSinkAlerthubArgs>) {
        this.sinkAlerthub = value
    }

    /**
     * @param value Configure alerts sent to CloudMonitor. See `sink_cms` below.
     */
    @JvmName("uojktkqkcerpwkck")
    public suspend fun sinkCms(`value`: Output<AlertConfigurationSinkCmsArgs>) {
        this.sinkCms = value
    }

    /**
     * @param value Configuration of sending alarms to EventStore. See `sink_event_store` below.
     */
    @JvmName("bqeeukatwsfynpti")
    public suspend fun sinkEventStore(`value`: Output<AlertConfigurationSinkEventStoreArgs>) {
        this.sinkEventStore = value
    }

    /**
     * @param value Customize the category of alarm monitoring rules.
     */
    @JvmName("vsyqbkenggxirfwj")
    public suspend fun tags(`value`: Output<List<String>>) {
        this.tags = value
    }

    @JvmName("twsmjrkburyedejt")
    public suspend fun tags(vararg values: Output<String>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values Customize the category of alarm monitoring rules.
     */
    @JvmName("qkrqqxanehrhhyid")
    public suspend fun tags(values: List<Output<String>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Alarm rule template configuration. See `template_configuration` below.
     */
    @JvmName("wrcxromnlcudffxo")
    public suspend fun templateConfiguration(`value`: Output<AlertConfigurationTemplateConfigurationArgs>) {
        this.templateConfiguration = value
    }

    /**
     * @param value Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
     */
    @JvmName("uckmexsowdrspduf")
    public suspend fun threshold(`value`: Output<Int>) {
        this.threshold = value
    }

    /**
     * @param value Template Type.
     */
    @JvmName("dfjtrihskexiamjt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Template Version.
     */
    @JvmName("asmenyvlwxoptxrr")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Template Annotations.
     */
    @JvmName("ekbnlebxfbfdoxqf")
    public suspend fun annotations(`value`: List<AlertConfigurationAnnotationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param argument Template Annotations.
     */
    @JvmName("ypeetxudmbyjaxxj")
    public suspend fun annotations(argument: List<suspend AlertConfigurationAnnotationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationAnnotationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument Template Annotations.
     */
    @JvmName("ithiiedogrhajwje")
    public suspend fun annotations(vararg argument: suspend AlertConfigurationAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationAnnotationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param argument Template Annotations.
     */
    @JvmName("qvftuuhohmvdspmn")
    public suspend fun annotations(argument: suspend AlertConfigurationAnnotationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertConfigurationAnnotationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param values Template Annotations.
     */
    @JvmName("scmrvnmfagvhpgeq")
    public suspend fun annotations(vararg values: AlertConfigurationAnnotationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
     */
    @JvmName("urmnbminewunrcpf")
    public suspend fun autoAnnotation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAnnotation = mapped
    }

    /**
     * @param value Alarm trigger condition. See `condition_configuration` below.
     */
    @JvmName("akmlhxmtijtjncgu")
    public suspend fun conditionConfiguration(`value`: AlertConfigurationConditionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionConfiguration = mapped
    }

    /**
     * @param argument Alarm trigger condition. See `condition_configuration` below.
     */
    @JvmName("ywbhdaqxivnxskbs")
    public suspend fun conditionConfiguration(argument: suspend AlertConfigurationConditionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationConditionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conditionConfiguration = mapped
    }

    /**
     * @param value The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
     */
    @JvmName("uksaqrdaxwvmsnlm")
    public suspend fun dashboard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboard = mapped
    }

    /**
     * @param value Group evaluation configuration. See `group_configuration` below.
     */
    @JvmName("huwgylxfjpxrtoul")
    public suspend fun groupConfiguration(`value`: AlertConfigurationGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupConfiguration = mapped
    }

    /**
     * @param argument Group evaluation configuration. See `group_configuration` below.
     */
    @JvmName("hbwlfnxasvvbfkjt")
    public suspend fun groupConfiguration(argument: suspend AlertConfigurationGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.groupConfiguration = mapped
    }

    /**
     * @param value Set operation configuration. See `join_configurations` below.
     */
    @JvmName("bkvmvcppmgunolah")
    public suspend fun joinConfigurations(`value`: List<AlertConfigurationJoinConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Set operation configuration. See `join_configurations` below.
     */
    @JvmName("fhbgoshhuhxemgjr")
    public suspend fun joinConfigurations(argument: List<suspend AlertConfigurationJoinConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationJoinConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Set operation configuration. See `join_configurations` below.
     */
    @JvmName("ofookrlacoagsuen")
    public suspend fun joinConfigurations(vararg argument: suspend AlertConfigurationJoinConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationJoinConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param argument Set operation configuration. See `join_configurations` below.
     */
    @JvmName("aogonexswgxfyyqw")
    public suspend fun joinConfigurations(argument: suspend AlertConfigurationJoinConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertConfigurationJoinConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.joinConfigurations = mapped
    }

    /**
     * @param values Set operation configuration. See `join_configurations` below.
     */
    @JvmName("novdcolxoshpanxa")
    public suspend fun joinConfigurations(vararg values: AlertConfigurationJoinConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.joinConfigurations = mapped
    }

    /**
     * @param value Label. See `labels` below.
     */
    @JvmName("vbungicewmeajfqe")
    public suspend fun labels(`value`: List<AlertConfigurationLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument Label. See `labels` below.
     */
    @JvmName("cknhenvtnaxkouvd")
    public suspend fun labels(argument: List<suspend AlertConfigurationLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument Label. See `labels` below.
     */
    @JvmName("gcnypggdvnkavpkl")
    public suspend fun labels(vararg argument: suspend AlertConfigurationLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument Label. See `labels` below.
     */
    @JvmName("dgfclnywcllyirny")
    public suspend fun labels(argument: suspend AlertConfigurationLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertConfigurationLabelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values Label. See `labels` below.
     */
    @JvmName("yibppnlbrbumuqjx")
    public suspend fun labels(vararg values: AlertConfigurationLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Second-level timestamp representing the temporary shutdown deadline.
     */
    @JvmName("mngokfnhwymitdab")
    public suspend fun muteUntil(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.muteUntil = mapped
    }

    /**
     * @param value Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
     */
    @JvmName("vsljnysncmhnldak")
    public suspend fun noDataFire(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDataFire = mapped
    }

    /**
     * @param value Alarm severity when no data triggers an alarm.
     */
    @JvmName("gqhfocckmhocymou")
    public suspend fun noDataSeverity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDataSeverity = mapped
    }

    /**
     * @param value Alert policy configuration. See `policy_configuration` below.
     */
    @JvmName("kurbialceggskgxx")
    public suspend fun policyConfiguration(`value`: AlertConfigurationPolicyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyConfiguration = mapped
    }

    /**
     * @param argument Alert policy configuration. See `policy_configuration` below.
     */
    @JvmName("gbfclesdrtaxxcqs")
    public suspend fun policyConfiguration(argument: suspend AlertConfigurationPolicyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationPolicyConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.policyConfiguration = mapped
    }

    /**
     * @param value Query the statistical list. See `query_list` below.
     */
    @JvmName("nfsaosromhgrvpfd")
    public suspend fun queryLists(`value`: List<AlertConfigurationQueryListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryLists = mapped
    }

    /**
     * @param argument Query the statistical list. See `query_list` below.
     */
    @JvmName("yeurklsafnqqtjkr")
    public suspend fun queryLists(argument: List<suspend AlertConfigurationQueryListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationQueryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param argument Query the statistical list. See `query_list` below.
     */
    @JvmName("jyxmmbmlyqsyhuve")
    public suspend fun queryLists(vararg argument: suspend AlertConfigurationQueryListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationQueryListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param argument Query the statistical list. See `query_list` below.
     */
    @JvmName("epufwdrspgqqjfar")
    public suspend fun queryLists(argument: suspend AlertConfigurationQueryListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertConfigurationQueryListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryLists = mapped
    }

    /**
     * @param values Query the statistical list. See `query_list` below.
     */
    @JvmName("ifflactuedpwcbpr")
    public suspend fun queryLists(vararg values: AlertConfigurationQueryListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryLists = mapped
    }

    /**
     * @param value Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
     */
    @JvmName("lvmdjjjddkyryvei")
    public suspend fun sendResolved(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendResolved = mapped
    }

    /**
     * @param value Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("ndnxilpwlrquulld")
    public suspend fun severityConfigurations(`value`: List<AlertConfigurationSeverityConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("yxjtmekaaxtxeyas")
    public suspend fun severityConfigurations(argument: List<suspend AlertConfigurationSeverityConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationSeverityConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("lhvtxrhtvkxbvnko")
    public suspend fun severityConfigurations(vararg argument: suspend AlertConfigurationSeverityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlertConfigurationSeverityConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param argument Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("ltoquohyjjscmmov")
    public suspend fun severityConfigurations(argument: suspend AlertConfigurationSeverityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertConfigurationSeverityConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.severityConfigurations = mapped
    }

    /**
     * @param values Trigger condition, set at least one trigger condition. See `severity_configurations` below.
     */
    @JvmName("njmtylssavleixbe")
    public suspend fun severityConfigurations(vararg values: AlertConfigurationSeverityConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severityConfigurations = mapped
    }

    /**
     * @param value Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
     */
    @JvmName("wwhiejyjtkglsark")
    public suspend fun sinkAlerthub(`value`: AlertConfigurationSinkAlerthubArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkAlerthub = mapped
    }

    /**
     * @param argument Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
     */
    @JvmName("cfxwunvlqdhiuinm")
    public suspend fun sinkAlerthub(argument: suspend AlertConfigurationSinkAlerthubArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationSinkAlerthubArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sinkAlerthub = mapped
    }

    /**
     * @param value Configure alerts sent to CloudMonitor. See `sink_cms` below.
     */
    @JvmName("atsvanuapjbjetwm")
    public suspend fun sinkCms(`value`: AlertConfigurationSinkCmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkCms = mapped
    }

    /**
     * @param argument Configure alerts sent to CloudMonitor. See `sink_cms` below.
     */
    @JvmName("stfaufpxbuxmbldm")
    public suspend fun sinkCms(argument: suspend AlertConfigurationSinkCmsArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationSinkCmsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sinkCms = mapped
    }

    /**
     * @param value Configuration of sending alarms to EventStore. See `sink_event_store` below.
     */
    @JvmName("nvrtiawfkapbxipp")
    public suspend fun sinkEventStore(`value`: AlertConfigurationSinkEventStoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkEventStore = mapped
    }

    /**
     * @param argument Configuration of sending alarms to EventStore. See `sink_event_store` below.
     */
    @JvmName("prwgomonmyugnpfd")
    public suspend fun sinkEventStore(argument: suspend AlertConfigurationSinkEventStoreArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationSinkEventStoreArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sinkEventStore = mapped
    }

    /**
     * @param value Customize the category of alarm monitoring rules.
     */
    @JvmName("xwxkmxuognegywrd")
    public suspend fun tags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Customize the category of alarm monitoring rules.
     */
    @JvmName("fexrimxnvhwusbre")
    public suspend fun tags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Alarm rule template configuration. See `template_configuration` below.
     */
    @JvmName("uqrarpsvbbdqlcjn")
    public suspend fun templateConfiguration(`value`: AlertConfigurationTemplateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateConfiguration = mapped
    }

    /**
     * @param argument Alarm rule template configuration. See `template_configuration` below.
     */
    @JvmName("tryryqoyfmbcubcg")
    public suspend fun templateConfiguration(argument: suspend AlertConfigurationTemplateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationTemplateConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.templateConfiguration = mapped
    }

    /**
     * @param value Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
     */
    @JvmName("hbnjgruhoglnpnod")
    public suspend fun threshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value Template Type.
     */
    @JvmName("ojnegoqmnjktwkfw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Template Version.
     */
    @JvmName("lgmacdpfdxxnxtlr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AlertConfigurationArgs = AlertConfigurationArgs(
        annotations = annotations,
        autoAnnotation = autoAnnotation,
        conditionConfiguration = conditionConfiguration,
        dashboard = dashboard,
        groupConfiguration = groupConfiguration,
        joinConfigurations = joinConfigurations,
        labels = labels,
        muteUntil = muteUntil,
        noDataFire = noDataFire,
        noDataSeverity = noDataSeverity,
        policyConfiguration = policyConfiguration,
        queryLists = queryLists,
        sendResolved = sendResolved,
        severityConfigurations = severityConfigurations,
        sinkAlerthub = sinkAlerthub,
        sinkCms = sinkCms,
        sinkEventStore = sinkEventStore,
        tags = tags,
        templateConfiguration = templateConfiguration,
        threshold = threshold,
        type = type,
        version = version,
    )
}
