@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fields The field used for grouping evaluation. When type is set to custom, fields must be set.
 * @property type
 */
public data class AlertConfigurationGroupConfigurationArgs(
    public val fields: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationGroupConfigurationArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationGroupConfigurationArgs.builder()
            .fields(fields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationGroupConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationGroupConfigurationArgsBuilder internal constructor() {
    private var fields: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The field used for grouping evaluation. When type is set to custom, fields must be set.
     */
    @JvmName("kudcxjjwrrvrxjjw")
    public suspend fun fields(`value`: Output<List<String>>) {
        this.fields = value
    }

    @JvmName("qysokokianwdgnaq")
    public suspend fun fields(vararg values: Output<String>) {
        this.fields = Output.all(values.asList())
    }

    /**
     * @param values The field used for grouping evaluation. When type is set to custom, fields must be set.
     */
    @JvmName("obvfqopoyeqoleta")
    public suspend fun fields(values: List<Output<String>>) {
        this.fields = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("hrufaaqjaaxpdasl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The field used for grouping evaluation. When type is set to custom, fields must be set.
     */
    @JvmName("rrnmkhbvyefyimkr")
    public suspend fun fields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param values The field used for grouping evaluation. When type is set to custom, fields must be set.
     */
    @JvmName("xkifxppjeosvpwkc")
    public suspend fun fields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fields = mapped
    }

    /**
     * @param value
     */
    @JvmName("qktotjjoklltatvi")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertConfigurationGroupConfigurationArgs =
        AlertConfigurationGroupConfigurationArgs(
            fields = fields,
            type = type,
        )
}
