@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationJoinConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property condition Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
 * @property type
 */
public data class AlertConfigurationJoinConfigurationArgs(
    public val condition: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationJoinConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationJoinConfigurationArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationJoinConfigurationArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationJoinConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationJoinConfigurationArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
     */
    @JvmName("epplimhlynewgybe")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value
     */
    @JvmName("tmpfvwlivavtrksc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
     */
    @JvmName("isqacswnsnslipod")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvgqewmbmwqyuyip")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertConfigurationJoinConfigurationArgs =
        AlertConfigurationJoinConfigurationArgs(
            condition = condition,
            type = type,
        )
}
