@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Field name.
 * @property value Field value.
 */
public data class AlertConfigurationLabelArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationLabelArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationLabelArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationLabelArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationLabelArgs].
 */
@PulumiTagMarker
public class AlertConfigurationLabelArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Field name.
     */
    @JvmName("cwffyrvsvmnjrfov")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Field value.
     */
    @JvmName("hbfvcjhoctiaxqxg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Field name.
     */
    @JvmName("fbwqcweweovlultx")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Field value.
     */
    @JvmName("chlalytvrsivnwuq")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AlertConfigurationLabelArgs = AlertConfigurationLabelArgs(
        key = key,
        `value` = `value`,
    )
}
