@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionPolicyId The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
 * @property alertPolicyId Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
 * @property repeatInterval Repeat the waiting time. For example, 5m, 1H, etc.
 */
public data class AlertConfigurationPolicyConfigurationArgs(
    public val actionPolicyId: Output<String>? = null,
    public val alertPolicyId: Output<String>? = null,
    public val repeatInterval: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationPolicyConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationPolicyConfigurationArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationPolicyConfigurationArgs.builder()
            .actionPolicyId(actionPolicyId?.applyValue({ args0 -> args0 }))
            .alertPolicyId(alertPolicyId?.applyValue({ args0 -> args0 }))
            .repeatInterval(repeatInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationPolicyConfigurationArgsBuilder internal constructor() {
    private var actionPolicyId: Output<String>? = null

    private var alertPolicyId: Output<String>? = null

    private var repeatInterval: Output<String>? = null

    /**
     * @param value The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
     */
    @JvmName("sisbmnwbpyyirkdn")
    public suspend fun actionPolicyId(`value`: Output<String>) {
        this.actionPolicyId = value
    }

    /**
     * @param value Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
     */
    @JvmName("intdnttotgwljpkb")
    public suspend fun alertPolicyId(`value`: Output<String>) {
        this.alertPolicyId = value
    }

    /**
     * @param value Repeat the waiting time. For example, 5m, 1H, etc.
     */
    @JvmName("qmnncbegupbrgunv")
    public suspend fun repeatInterval(`value`: Output<String>) {
        this.repeatInterval = value
    }

    /**
     * @param value The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
     */
    @JvmName("qacknbxisyeqnwdm")
    public suspend fun actionPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPolicyId = mapped
    }

    /**
     * @param value Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
     */
    @JvmName("ilclyhfpyxwvodun")
    public suspend fun alertPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertPolicyId = mapped
    }

    /**
     * @param value Repeat the waiting time. For example, 5m, 1H, etc.
     */
    @JvmName("qcblioukibvntqph")
    public suspend fun repeatInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repeatInterval = mapped
    }

    internal fun build(): AlertConfigurationPolicyConfigurationArgs =
        AlertConfigurationPolicyConfigurationArgs(
            actionPolicyId = actionPolicyId,
            alertPolicyId = alertPolicyId,
            repeatInterval = repeatInterval,
        )
}
