@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationQueryListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property chartTitle Chart Name.
 * @property dashboardId Dashboard ID.
 * @property end End time. When storeType is set to log or metric, end must be set.
 * @property powerSqlMode Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
 * @property project Project Name.
 * @property query Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
 * @property region Region of the target Project.
 * @property roleArn Roles used to write alarm data to the event Library.
 * @property start Start time. When storeType is set to log or metric, start must be set.
 * @property store Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
 * @property storeType Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
 * @property timeSpanType Time Type.
 * @property ui Use of specific scene alarm front end.
 */
public data class AlertConfigurationQueryListArgs(
    public val chartTitle: Output<String>? = null,
    public val dashboardId: Output<String>? = null,
    public val end: Output<String>? = null,
    public val powerSqlMode: Output<String>? = null,
    public val project: Output<String>? = null,
    public val query: Output<String>? = null,
    public val region: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val start: Output<String>? = null,
    public val store: Output<String>? = null,
    public val storeType: Output<String>? = null,
    public val timeSpanType: Output<String>? = null,
    public val ui: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationQueryListArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationQueryListArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationQueryListArgs.builder()
            .chartTitle(chartTitle?.applyValue({ args0 -> args0 }))
            .dashboardId(dashboardId?.applyValue({ args0 -> args0 }))
            .end(end?.applyValue({ args0 -> args0 }))
            .powerSqlMode(powerSqlMode?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 }))
            .store(store?.applyValue({ args0 -> args0 }))
            .storeType(storeType?.applyValue({ args0 -> args0 }))
            .timeSpanType(timeSpanType?.applyValue({ args0 -> args0 }))
            .ui(ui?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationQueryListArgs].
 */
@PulumiTagMarker
public class AlertConfigurationQueryListArgsBuilder internal constructor() {
    private var chartTitle: Output<String>? = null

    private var dashboardId: Output<String>? = null

    private var end: Output<String>? = null

    private var powerSqlMode: Output<String>? = null

    private var project: Output<String>? = null

    private var query: Output<String>? = null

    private var region: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var start: Output<String>? = null

    private var store: Output<String>? = null

    private var storeType: Output<String>? = null

    private var timeSpanType: Output<String>? = null

    private var ui: Output<String>? = null

    /**
     * @param value Chart Name.
     */
    @JvmName("qvrsxvjfafdsmgih")
    public suspend fun chartTitle(`value`: Output<String>) {
        this.chartTitle = value
    }

    /**
     * @param value Dashboard ID.
     */
    @JvmName("dymcqecpvrsibrcp")
    public suspend fun dashboardId(`value`: Output<String>) {
        this.dashboardId = value
    }

    /**
     * @param value End time. When storeType is set to log or metric, end must be set.
     */
    @JvmName("biwpjynbbdmrotxv")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
     */
    @JvmName("fpdpndqhconxsdaf")
    public suspend fun powerSqlMode(`value`: Output<String>) {
        this.powerSqlMode = value
    }

    /**
     * @param value Project Name.
     */
    @JvmName("qeanudjinueonryg")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
     */
    @JvmName("tuhqjqvupaqcnpvt")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Region of the target Project.
     */
    @JvmName("tgdqsyafcnqpbcqr")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Roles used to write alarm data to the event Library.
     */
    @JvmName("mkjqmukjmqjahlxc")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Start time. When storeType is set to log or metric, start must be set.
     */
    @JvmName("iemeokkjlufmtpmq")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
     */
    @JvmName("bjmqxjcklkavmuds")
    public suspend fun store(`value`: Output<String>) {
        this.store = value
    }

    /**
     * @param value Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
     */
    @JvmName("oevgfjtipmehioeo")
    public suspend fun storeType(`value`: Output<String>) {
        this.storeType = value
    }

    /**
     * @param value Time Type.
     */
    @JvmName("oglvwyntxxrxbwqv")
    public suspend fun timeSpanType(`value`: Output<String>) {
        this.timeSpanType = value
    }

    /**
     * @param value Use of specific scene alarm front end.
     */
    @JvmName("ohpkhxfewdyaoywo")
    public suspend fun ui(`value`: Output<String>) {
        this.ui = value
    }

    /**
     * @param value Chart Name.
     */
    @JvmName("masjuqxxxtxvbelv")
    public suspend fun chartTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chartTitle = mapped
    }

    /**
     * @param value Dashboard ID.
     */
    @JvmName("pughotumjvlvdfpp")
    public suspend fun dashboardId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardId = mapped
    }

    /**
     * @param value End time. When storeType is set to log or metric, end must be set.
     */
    @JvmName("qlfhhyaliqursyko")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
     */
    @JvmName("pnqkioawopccbpxv")
    public suspend fun powerSqlMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerSqlMode = mapped
    }

    /**
     * @param value Project Name.
     */
    @JvmName("xryergiijiqiwuyg")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
     */
    @JvmName("favfdaumqflyrprh")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Region of the target Project.
     */
    @JvmName("hklvfbqaevnmdewl")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Roles used to write alarm data to the event Library.
     */
    @JvmName("gihdpvrogyoskilt")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Start time. When storeType is set to log or metric, start must be set.
     */
    @JvmName("vcokkpiwwjrisoiy")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
     */
    @JvmName("bksdjigqjegpcxyg")
    public suspend fun store(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.store = mapped
    }

    /**
     * @param value Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
     */
    @JvmName("oxigagfnaqjewhcn")
    public suspend fun storeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeType = mapped
    }

    /**
     * @param value Time Type.
     */
    @JvmName("myfwvsyeifkofsje")
    public suspend fun timeSpanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSpanType = mapped
    }

    /**
     * @param value Use of specific scene alarm front end.
     */
    @JvmName("ptpwtdyplrhoravn")
    public suspend fun ui(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ui = mapped
    }

    internal fun build(): AlertConfigurationQueryListArgs = AlertConfigurationQueryListArgs(
        chartTitle = chartTitle,
        dashboardId = dashboardId,
        end = end,
        powerSqlMode = powerSqlMode,
        project = project,
        query = query,
        region = region,
        roleArn = roleArn,
        start = start,
        store = store,
        storeType = storeType,
        timeSpanType = timeSpanType,
        ui = ui,
    )
}
