@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property evalCondition Trigger condition. See `eval_condition` below.
 * @property severity Alarm severity.
 */
public data class AlertConfigurationSeverityConfigurationArgs(
    public val evalCondition: Output<AlertConfigurationSeverityConfigurationEvalConditionArgs>? =
        null,
    public val severity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationArgs = com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationArgs.builder()
        .evalCondition(evalCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .severity(severity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationSeverityConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationSeverityConfigurationArgsBuilder internal constructor() {
    private var evalCondition: Output<AlertConfigurationSeverityConfigurationEvalConditionArgs>? =
        null

    private var severity: Output<Int>? = null

    /**
     * @param value Trigger condition. See `eval_condition` below.
     */
    @JvmName("wsomlnxtvunsigsy")
    public suspend fun evalCondition(`value`: Output<AlertConfigurationSeverityConfigurationEvalConditionArgs>) {
        this.evalCondition = value
    }

    /**
     * @param value Alarm severity.
     */
    @JvmName("txjtfsrrypcsusqn")
    public suspend fun severity(`value`: Output<Int>) {
        this.severity = value
    }

    /**
     * @param value Trigger condition. See `eval_condition` below.
     */
    @JvmName("dydyvvdbhrxclkdp")
    public suspend fun evalCondition(`value`: AlertConfigurationSeverityConfigurationEvalConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evalCondition = mapped
    }

    /**
     * @param argument Trigger condition. See `eval_condition` below.
     */
    @JvmName("wspvlfxgrsnwkrbh")
    public suspend fun evalCondition(argument: suspend AlertConfigurationSeverityConfigurationEvalConditionArgsBuilder.() -> Unit) {
        val toBeMapped = AlertConfigurationSeverityConfigurationEvalConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.evalCondition = mapped
    }

    /**
     * @param value Alarm severity.
     */
    @JvmName("mcipvgjesyusrjcr")
    public suspend fun severity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    internal fun build(): AlertConfigurationSeverityConfigurationArgs =
        AlertConfigurationSeverityConfigurationArgs(
            evalCondition = evalCondition,
            severity = severity,
        )
}
