@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationEvalConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property condition Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
 * @property countCondition The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
 */
public data class AlertConfigurationSeverityConfigurationEvalConditionArgs(
    public val condition: Output<String>? = null,
    public val countCondition: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationEvalConditionArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationEvalConditionArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationSeverityConfigurationEvalConditionArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .countCondition(countCondition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationSeverityConfigurationEvalConditionArgs].
 */
@PulumiTagMarker
public class AlertConfigurationSeverityConfigurationEvalConditionArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var countCondition: Output<String>? = null

    /**
     * @param value Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
     */
    @JvmName("alxgqhiuxpwnceoa")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
     */
    @JvmName("jtlobvxqobjjaeut")
    public suspend fun countCondition(`value`: Output<String>) {
        this.countCondition = value
    }

    /**
     * @param value Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
     */
    @JvmName("amhycselnipcpxhy")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
     */
    @JvmName("ygfhledetghhsxwr")
    public suspend fun countCondition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countCondition = mapped
    }

    internal fun build(): AlertConfigurationSeverityConfigurationEvalConditionArgs =
        AlertConfigurationSeverityConfigurationEvalConditionArgs(
            condition = condition,
            countCondition = countCondition,
        )
}
