@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkCmsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Open.
 */
public data class AlertConfigurationSinkCmsArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkCmsArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkCmsArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkCmsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationSinkCmsArgs].
 */
@PulumiTagMarker
public class AlertConfigurationSinkCmsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Open.
     */
    @JvmName("dcygalgkayknevpj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Open.
     */
    @JvmName("qlphgpidgqjrklkh")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): AlertConfigurationSinkCmsArgs = AlertConfigurationSinkCmsArgs(
        enabled = enabled,
    )
}
