@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkEventStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Open.
 * @property endpoint SLS service endpoint.
 * @property eventStore Event Library Name.
 * @property project Project Name.
 * @property roleArn Roles used to write alarm data to the event Library.
 */
public data class AlertConfigurationSinkEventStoreArgs(
    public val enabled: Output<Boolean>? = null,
    public val endpoint: Output<String>? = null,
    public val eventStore: Output<String>? = null,
    public val project: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkEventStoreArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkEventStoreArgs =
        com.pulumi.alicloud.sls.inputs.AlertConfigurationSinkEventStoreArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .eventStore(eventStore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationSinkEventStoreArgs].
 */
@PulumiTagMarker
public class AlertConfigurationSinkEventStoreArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var endpoint: Output<String>? = null

    private var eventStore: Output<String>? = null

    private var project: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Open.
     */
    @JvmName("fxusmjoqjmdttgiq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value SLS service endpoint.
     */
    @JvmName("ucnwmastembykaps")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Event Library Name.
     */
    @JvmName("nisavhvphetemtkg")
    public suspend fun eventStore(`value`: Output<String>) {
        this.eventStore = value
    }

    /**
     * @param value Project Name.
     */
    @JvmName("debsptbxtnlnotsd")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Roles used to write alarm data to the event Library.
     */
    @JvmName("mgmwlcxpmiftrtcf")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Open.
     */
    @JvmName("uyyiiugjwycbqumf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value SLS service endpoint.
     */
    @JvmName("fdtidbtpsopsggec")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Event Library Name.
     */
    @JvmName("swufogamyfwyurhc")
    public suspend fun eventStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventStore = mapped
    }

    /**
     * @param value Project Name.
     */
    @JvmName("ickgegpoxoeekhml")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Roles used to write alarm data to the event Library.
     */
    @JvmName("txkpugsryeivoiua")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AlertConfigurationSinkEventStoreArgs = AlertConfigurationSinkEventStoreArgs(
        enabled = enabled,
        endpoint = endpoint,
        eventStore = eventStore,
        project = project,
        roleArn = roleArn,
    )
}
