@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertConfigurationTemplateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property annotations Template Annotations.
 * @property lang Template Language.
 * @property templateId Template ID.
 * @property tokens Template Variables.
 * @property type
 * @property version Template Version.
 */
public data class AlertConfigurationTemplateConfigurationArgs(
    public val annotations: Output<Map<String, String>>? = null,
    public val lang: Output<String>? = null,
    public val templateId: Output<String>? = null,
    public val tokens: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertConfigurationTemplateConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertConfigurationTemplateConfigurationArgs = com.pulumi.alicloud.sls.inputs.AlertConfigurationTemplateConfigurationArgs.builder()
        .annotations(
            annotations?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .lang(lang?.applyValue({ args0 -> args0 }))
        .templateId(templateId?.applyValue({ args0 -> args0 }))
        .tokens(tokens?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .type(type?.applyValue({ args0 -> args0 }))
        .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertConfigurationTemplateConfigurationArgs].
 */
@PulumiTagMarker
public class AlertConfigurationTemplateConfigurationArgsBuilder internal constructor() {
    private var annotations: Output<Map<String, String>>? = null

    private var lang: Output<String>? = null

    private var templateId: Output<String>? = null

    private var tokens: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Template Annotations.
     */
    @JvmName("bsdpvcdcelyaiduk")
    public suspend fun annotations(`value`: Output<Map<String, String>>) {
        this.annotations = value
    }

    /**
     * @param value Template Language.
     */
    @JvmName("vxfmveysoxqhemxh")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Template ID.
     */
    @JvmName("qpmsohtwmendxpqd")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Template Variables.
     */
    @JvmName("evwprgadiwhpaiua")
    public suspend fun tokens(`value`: Output<Map<String, String>>) {
        this.tokens = value
    }

    /**
     * @param value
     */
    @JvmName("gyqgrasvinthdcuk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Template Version.
     */
    @JvmName("igtbritcilscqfgx")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Template Annotations.
     */
    @JvmName("kpxlgeruqxygqwfk")
    public suspend fun annotations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values Template Annotations.
     */
    @JvmName("mcaipewqqdqrajin")
    public fun annotations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Template Language.
     */
    @JvmName("dwichxihucsnbfwp")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Template ID.
     */
    @JvmName("vvxhmhxtpclvhepq")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Template Variables.
     */
    @JvmName("tkfhdddlywdkppeo")
    public suspend fun tokens(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    /**
     * @param values Template Variables.
     */
    @JvmName("ckooksqsnxcipddx")
    public fun tokens(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    /**
     * @param value
     */
    @JvmName("fkhtpbdoxqvnbnql")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Template Version.
     */
    @JvmName("jktcpnfovsipjdkw")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AlertConfigurationTemplateConfigurationArgs =
        AlertConfigurationTemplateConfigurationArgs(
            annotations = annotations,
            lang = lang,
            templateId = templateId,
            tokens = tokens,
            type = type,
            version = version,
        )
}
