@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.AlertScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cronExpression Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
 * @property delay Timed task execution delay (unit: s).
 * @property interval Fixed interval for scheduling.
 * @property runImmdiately Dispatch immediately.
 * @property timeZone The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
 * @property type Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
 */
public data class AlertScheduleArgs(
    public val cronExpression: Output<String>? = null,
    public val delay: Output<Int>? = null,
    public val interval: Output<String>? = null,
    public val runImmdiately: Output<Boolean>? = null,
    public val timeZone: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.AlertScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.AlertScheduleArgs =
        com.pulumi.alicloud.sls.inputs.AlertScheduleArgs.builder()
            .cronExpression(cronExpression?.applyValue({ args0 -> args0 }))
            .delay(delay?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .runImmdiately(runImmdiately?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertScheduleArgs].
 */
@PulumiTagMarker
public class AlertScheduleArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    private var delay: Output<Int>? = null

    private var interval: Output<String>? = null

    private var runImmdiately: Output<Boolean>? = null

    private var timeZone: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
     */
    @JvmName("lkqtyrweekmlaire")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value Timed task execution delay (unit: s).
     */
    @JvmName("abinntjautiiiofo")
    public suspend fun delay(`value`: Output<Int>) {
        this.delay = value
    }

    /**
     * @param value Fixed interval for scheduling.
     */
    @JvmName("adtgxjeypjsrfwba")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value Dispatch immediately.
     */
    @JvmName("dwyfatxgdmqmwktw")
    public suspend fun runImmdiately(`value`: Output<Boolean>) {
        this.runImmdiately = value
    }

    /**
     * @param value The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
     */
    @JvmName("ojllxjlpoxcubqjp")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
     */
    @JvmName("prnrugurrveahklx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
     */
    @JvmName("sinmchdgostbpcws")
    public suspend fun cronExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    /**
     * @param value Timed task execution delay (unit: s).
     */
    @JvmName("tqdpfqenpqhohjjd")
    public suspend fun delay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delay = mapped
    }

    /**
     * @param value Fixed interval for scheduling.
     */
    @JvmName("ounrqoeoljbqqrfu")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Dispatch immediately.
     */
    @JvmName("jlpiohikldkeadno")
    public suspend fun runImmdiately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runImmdiately = mapped
    }

    /**
     * @param value The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
     */
    @JvmName("lccnvhhiyicchxxs")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
     */
    @JvmName("rhnbfagsnwlblkdo")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AlertScheduleArgs = AlertScheduleArgs(
        cronExpression = cronExpression,
        delay = delay,
        interval = interval,
        runImmdiately = runImmdiately,
        timeZone = timeZone,
        type = type,
    )
}
