@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cronExpression Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
 * @property delay Delay time.
 * @property interval Time interval, such as 5m, 1H.
 * @property runImmediately Whether to execute the OSS import task immediately after it is created.
 * @property timeZone Time Zone.
 * @property type Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
 */
public data class ScheduledSqlScheduleArgs(
    public val cronExpression: Output<String>? = null,
    public val delay: Output<Int>? = null,
    public val interval: Output<String>? = null,
    public val runImmediately: Output<Boolean>? = null,
    public val timeZone: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduleArgs =
        com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduleArgs.builder()
            .cronExpression(cronExpression?.applyValue({ args0 -> args0 }))
            .delay(delay?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .runImmediately(runImmediately?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledSqlScheduleArgs].
 */
@PulumiTagMarker
public class ScheduledSqlScheduleArgsBuilder internal constructor() {
    private var cronExpression: Output<String>? = null

    private var delay: Output<Int>? = null

    private var interval: Output<String>? = null

    private var runImmediately: Output<Boolean>? = null

    private var timeZone: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
     */
    @JvmName("uwcagkcqtbndikig")
    public suspend fun cronExpression(`value`: Output<String>) {
        this.cronExpression = value
    }

    /**
     * @param value Delay time.
     */
    @JvmName("vdotxbeimkvitecu")
    public suspend fun delay(`value`: Output<Int>) {
        this.delay = value
    }

    /**
     * @param value Time interval, such as 5m, 1H.
     */
    @JvmName("jdrpjpgewcrldkbe")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value Whether to execute the OSS import task immediately after it is created.
     */
    @JvmName("nfrctgetetuesonq")
    public suspend fun runImmediately(`value`: Output<Boolean>) {
        this.runImmediately = value
    }

    /**
     * @param value Time Zone.
     */
    @JvmName("vliliqqykchofvya")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
     */
    @JvmName("ffvhavrkathlqdqj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
     */
    @JvmName("wlxggptnddapceng")
    public suspend fun cronExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cronExpression = mapped
    }

    /**
     * @param value Delay time.
     */
    @JvmName("xtrfrrvymkfoffoh")
    public suspend fun delay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delay = mapped
    }

    /**
     * @param value Time interval, such as 5m, 1H.
     */
    @JvmName("awaxwtekdvgvukpf")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Whether to execute the OSS import task immediately after it is created.
     */
    @JvmName("dfbjclbpcbjfqfta")
    public suspend fun runImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runImmediately = mapped
    }

    /**
     * @param value Time Zone.
     */
    @JvmName("ugpryoimlrsrygns")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
     */
    @JvmName("nbbqxhfxuxyuhifc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScheduledSqlScheduleArgs = ScheduledSqlScheduleArgs(
        cronExpression = cronExpression,
        delay = delay,
        interval = interval,
        runImmediately = runImmediately,
        timeZone = timeZone,
        type = type,
    )
}
