@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.inputs

import com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduledSqlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dataFormat Write Mode.
 * @property destEndpoint Target Endpoint.
 * @property destLogstore Target Logstore.
 * @property destProject Target Project.
 * @property destRoleArn Write target role ARN.
 * @property fromTime Schedule Start Time.
 * @property fromTimeExpr SQL time window-start.
 * @property maxRetries Maximum retries.
 * @property maxRunTimeInSeconds SQL timeout.
 * @property parameters Parameter configuration.
 * @property resourcePool Resource Pool.
 * @property roleArn Read role ARN.
 * @property script SQL statement.
 * @property sourceLogstore Source Logstore.
 * @property sqlType SQL type.
 * @property toTime Time at end of schedule.
 * @property toTimeExpr SQL time window-end.
 */
public data class ScheduledSqlScheduledSqlConfigurationArgs(
    public val dataFormat: Output<String>? = null,
    public val destEndpoint: Output<String>? = null,
    public val destLogstore: Output<String>? = null,
    public val destProject: Output<String>? = null,
    public val destRoleArn: Output<String>? = null,
    public val fromTime: Output<Int>? = null,
    public val fromTimeExpr: Output<String>? = null,
    public val maxRetries: Output<Int>? = null,
    public val maxRunTimeInSeconds: Output<Int>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourcePool: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val script: Output<String>? = null,
    public val sourceLogstore: Output<String>? = null,
    public val sqlType: Output<String>? = null,
    public val toTime: Output<Int>? = null,
    public val toTimeExpr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduledSqlConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduledSqlConfigurationArgs =
        com.pulumi.alicloud.sls.inputs.ScheduledSqlScheduledSqlConfigurationArgs.builder()
            .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
            .destEndpoint(destEndpoint?.applyValue({ args0 -> args0 }))
            .destLogstore(destLogstore?.applyValue({ args0 -> args0 }))
            .destProject(destProject?.applyValue({ args0 -> args0 }))
            .destRoleArn(destRoleArn?.applyValue({ args0 -> args0 }))
            .fromTime(fromTime?.applyValue({ args0 -> args0 }))
            .fromTimeExpr(fromTimeExpr?.applyValue({ args0 -> args0 }))
            .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
            .maxRunTimeInSeconds(maxRunTimeInSeconds?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourcePool(resourcePool?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .script(script?.applyValue({ args0 -> args0 }))
            .sourceLogstore(sourceLogstore?.applyValue({ args0 -> args0 }))
            .sqlType(sqlType?.applyValue({ args0 -> args0 }))
            .toTime(toTime?.applyValue({ args0 -> args0 }))
            .toTimeExpr(toTimeExpr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledSqlScheduledSqlConfigurationArgs].
 */
@PulumiTagMarker
public class ScheduledSqlScheduledSqlConfigurationArgsBuilder internal constructor() {
    private var dataFormat: Output<String>? = null

    private var destEndpoint: Output<String>? = null

    private var destLogstore: Output<String>? = null

    private var destProject: Output<String>? = null

    private var destRoleArn: Output<String>? = null

    private var fromTime: Output<Int>? = null

    private var fromTimeExpr: Output<String>? = null

    private var maxRetries: Output<Int>? = null

    private var maxRunTimeInSeconds: Output<Int>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourcePool: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var script: Output<String>? = null

    private var sourceLogstore: Output<String>? = null

    private var sqlType: Output<String>? = null

    private var toTime: Output<Int>? = null

    private var toTimeExpr: Output<String>? = null

    /**
     * @param value Write Mode.
     */
    @JvmName("voyptsefbeuijmon")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value Target Endpoint.
     */
    @JvmName("ixwsbirerbwpeste")
    public suspend fun destEndpoint(`value`: Output<String>) {
        this.destEndpoint = value
    }

    /**
     * @param value Target Logstore.
     */
    @JvmName("kswvwceyvwonwcjb")
    public suspend fun destLogstore(`value`: Output<String>) {
        this.destLogstore = value
    }

    /**
     * @param value Target Project.
     */
    @JvmName("foojyxoutglnidvx")
    public suspend fun destProject(`value`: Output<String>) {
        this.destProject = value
    }

    /**
     * @param value Write target role ARN.
     */
    @JvmName("tnuwstqmbnxhfqph")
    public suspend fun destRoleArn(`value`: Output<String>) {
        this.destRoleArn = value
    }

    /**
     * @param value Schedule Start Time.
     */
    @JvmName("ktvwmqtyaecvpkxg")
    public suspend fun fromTime(`value`: Output<Int>) {
        this.fromTime = value
    }

    /**
     * @param value SQL time window-start.
     */
    @JvmName("tdahoaquluubdyww")
    public suspend fun fromTimeExpr(`value`: Output<String>) {
        this.fromTimeExpr = value
    }

    /**
     * @param value Maximum retries.
     */
    @JvmName("jkvwfitvqjbevyes")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value SQL timeout.
     */
    @JvmName("ddtugnobeotgqubl")
    public suspend fun maxRunTimeInSeconds(`value`: Output<Int>) {
        this.maxRunTimeInSeconds = value
    }

    /**
     * @param value Parameter configuration.
     */
    @JvmName("gpgmiwhhqlcpdcsg")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Resource Pool.
     */
    @JvmName("gdsuxyxiktyedpas")
    public suspend fun resourcePool(`value`: Output<String>) {
        this.resourcePool = value
    }

    /**
     * @param value Read role ARN.
     */
    @JvmName("avqswvcqmnepdcuf")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value SQL statement.
     */
    @JvmName("bekjcggrljidqqnh")
    public suspend fun script(`value`: Output<String>) {
        this.script = value
    }

    /**
     * @param value Source Logstore.
     */
    @JvmName("devrkmrxsyknmupb")
    public suspend fun sourceLogstore(`value`: Output<String>) {
        this.sourceLogstore = value
    }

    /**
     * @param value SQL type.
     */
    @JvmName("hupjdurfrqystglo")
    public suspend fun sqlType(`value`: Output<String>) {
        this.sqlType = value
    }

    /**
     * @param value Time at end of schedule.
     */
    @JvmName("jomktcyoigawwqea")
    public suspend fun toTime(`value`: Output<Int>) {
        this.toTime = value
    }

    /**
     * @param value SQL time window-end.
     */
    @JvmName("kjfhqbnkbcnfurxp")
    public suspend fun toTimeExpr(`value`: Output<String>) {
        this.toTimeExpr = value
    }

    /**
     * @param value Write Mode.
     */
    @JvmName("esikwvsudbjqawqr")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Target Endpoint.
     */
    @JvmName("somegqhotyonatvq")
    public suspend fun destEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destEndpoint = mapped
    }

    /**
     * @param value Target Logstore.
     */
    @JvmName("ulqaualvmgkdwuqt")
    public suspend fun destLogstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destLogstore = mapped
    }

    /**
     * @param value Target Project.
     */
    @JvmName("qhplynhyuqkllash")
    public suspend fun destProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destProject = mapped
    }

    /**
     * @param value Write target role ARN.
     */
    @JvmName("qhpnkcahvllybxth")
    public suspend fun destRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destRoleArn = mapped
    }

    /**
     * @param value Schedule Start Time.
     */
    @JvmName("jbgdlaqopxnosrud")
    public suspend fun fromTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromTime = mapped
    }

    /**
     * @param value SQL time window-start.
     */
    @JvmName("mqsaatvpbucpxiyx")
    public suspend fun fromTimeExpr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromTimeExpr = mapped
    }

    /**
     * @param value Maximum retries.
     */
    @JvmName("bxpbhsxrfauctkfb")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value SQL timeout.
     */
    @JvmName("htiqoaiwdwuyasot")
    public suspend fun maxRunTimeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRunTimeInSeconds = mapped
    }

    /**
     * @param value Parameter configuration.
     */
    @JvmName("vxgrbhttqrcjvemx")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Parameter configuration.
     */
    @JvmName("tjfqwfccsqsuwvkj")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Resource Pool.
     */
    @JvmName("hokwimrrsislcnac")
    public suspend fun resourcePool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePool = mapped
    }

    /**
     * @param value Read role ARN.
     */
    @JvmName("wedphbkaqsmrnlky")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value SQL statement.
     */
    @JvmName("dikoqjeodsrcrorg")
    public suspend fun script(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.script = mapped
    }

    /**
     * @param value Source Logstore.
     */
    @JvmName("usfqhgidktukldbh")
    public suspend fun sourceLogstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLogstore = mapped
    }

    /**
     * @param value SQL type.
     */
    @JvmName("bwdgkbvetfxwcumt")
    public suspend fun sqlType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlType = mapped
    }

    /**
     * @param value Time at end of schedule.
     */
    @JvmName("fclbnqyydfohwduh")
    public suspend fun toTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toTime = mapped
    }

    /**
     * @param value SQL time window-end.
     */
    @JvmName("oieyejhflyfdqbce")
    public suspend fun toTimeExpr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toTimeExpr = mapped
    }

    internal fun build(): ScheduledSqlScheduledSqlConfigurationArgs =
        ScheduledSqlScheduledSqlConfigurationArgs(
            dataFormat = dataFormat,
            destEndpoint = destEndpoint,
            destLogstore = destLogstore,
            destProject = destProject,
            destRoleArn = destRoleArn,
            fromTime = fromTime,
            fromTimeExpr = fromTimeExpr,
            maxRetries = maxRetries,
            maxRunTimeInSeconds = maxRunTimeInSeconds,
            parameters = parameters,
            resourcePool = resourcePool,
            roleArn = roleArn,
            script = script,
            sourceLogstore = sourceLogstore,
            sqlType = sqlType,
            toTime = toTime,
            toTimeExpr = toTimeExpr,
        )
}
