@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property annotations Template Annotations.
 * @property autoAnnotation Whether to turn on automatic labeling. true (default): The automatic annotation function is enabled, and the system automatically adds information such as__county__to the alarm. For more information, see Automatic Labeling. false: Turn off the automatic annotation function.
 * @property conditionConfiguration Alarm trigger condition. See `condition_configuration` below.
 * @property dashboard The instrument cluster associated with the alarm. It is recommended to set to internal-alert-analysis.
 * @property groupConfiguration Group evaluation configuration. See `group_configuration` below.
 * @property joinConfigurations Set operation configuration. See `join_configurations` below.
 * @property labels Label. See `labels` below.
 * @property muteUntil Second-level timestamp representing the temporary shutdown deadline.
 * @property noDataFire Whether no data triggers an alarm. true: If the number of times the query and analysis results (if there are multiple results, the result after the collection operation) is no data exceeds the continuous trigger threshold, an alarm is generated. false (default): Turn off the no data alarm function.
 * @property noDataSeverity Alarm severity when no data triggers an alarm.
 * @property policyConfiguration Alert policy configuration. See `policy_configuration` below.
 * @property queryLists Query the statistical list. See `query_list` below.
 * @property sendResolved Whether to send a recovery notification. true: A recovery alarm is triggered when the alarm is restored. false (default): Turn off the alarm recovery notification function.
 * @property severityConfigurations Trigger condition, set at least one trigger condition. See `severity_configurations` below.
 * @property sinkAlerthub Configuration of Alerts Sent to Alerthub. See `sink_alerthub` below.
 * @property sinkCms Configure alerts sent to CloudMonitor. See `sink_cms` below.
 * @property sinkEventStore Configuration of sending alarms to EventStore. See `sink_event_store` below.
 * @property tags Customize the category of alarm monitoring rules.
 * @property templateConfiguration Alarm rule template configuration. See `template_configuration` below.
 * @property threshold Set the continuous trigger threshold. When the cumulative number of triggers reaches this value, an alarm is generated. The statistics are not counted when the trigger condition is not met.
 * @property type Template Type.
 * @property version Template Version.
 */
public data class AlertConfiguration(
    public val annotations: List<AlertConfigurationAnnotation>? = null,
    public val autoAnnotation: Boolean? = null,
    public val conditionConfiguration: AlertConfigurationConditionConfiguration? = null,
    public val dashboard: String? = null,
    public val groupConfiguration: AlertConfigurationGroupConfiguration? = null,
    public val joinConfigurations: List<AlertConfigurationJoinConfiguration>? = null,
    public val labels: List<AlertConfigurationLabel>? = null,
    public val muteUntil: Int? = null,
    public val noDataFire: Boolean? = null,
    public val noDataSeverity: Int? = null,
    public val policyConfiguration: AlertConfigurationPolicyConfiguration? = null,
    public val queryLists: List<AlertConfigurationQueryList>? = null,
    public val sendResolved: Boolean? = null,
    public val severityConfigurations: List<AlertConfigurationSeverityConfiguration>? = null,
    public val sinkAlerthub: AlertConfigurationSinkAlerthub? = null,
    public val sinkCms: AlertConfigurationSinkCms? = null,
    public val sinkEventStore: AlertConfigurationSinkEventStore? = null,
    public val tags: List<String>? = null,
    public val templateConfiguration: AlertConfigurationTemplateConfiguration? = null,
    public val threshold: Int? = null,
    public val type: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfiguration): AlertConfiguration = AlertConfiguration(
            annotations = javaType.annotations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationAnnotation.Companion.toKotlin(args0)
                })
            }),
            autoAnnotation = javaType.autoAnnotation().map({ args0 -> args0 }).orElse(null),
            conditionConfiguration = javaType.conditionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationConditionConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dashboard = javaType.dashboard().map({ args0 -> args0 }).orElse(null),
            groupConfiguration = javaType.groupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationGroupConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            joinConfigurations = javaType.joinConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationJoinConfiguration.Companion.toKotlin(args0)
                })
            }),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationLabel.Companion.toKotlin(args0)
                })
            }),
            muteUntil = javaType.muteUntil().map({ args0 -> args0 }).orElse(null),
            noDataFire = javaType.noDataFire().map({ args0 -> args0 }).orElse(null),
            noDataSeverity = javaType.noDataSeverity().map({ args0 -> args0 }).orElse(null),
            policyConfiguration = javaType.policyConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationPolicyConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryLists = javaType.queryLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationQueryList.Companion.toKotlin(args0)
                })
            }),
            sendResolved = javaType.sendResolved().map({ args0 -> args0 }).orElse(null),
            severityConfigurations = javaType.severityConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationSeverityConfiguration.Companion.toKotlin(args0)
                })
            }),
            sinkAlerthub = javaType.sinkAlerthub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationSinkAlerthub.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sinkCms = javaType.sinkCms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationSinkCms.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sinkEventStore = javaType.sinkEventStore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationSinkEventStore.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0 }),
            templateConfiguration = javaType.templateConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.sls.kotlin.outputs.AlertConfigurationTemplateConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
