@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property condition Data matching expression. When the data content does not need to be determined, set it to an empty string. In other cases, it needs to be set as an expression, for example, errCnt> 10.
 * @property countCondition The number of pieces of data to determine the number of pieces of data to indicate how many pieces of data meet the conditions. If data exists, it is satisfied. Set it to an empty string. In other cases, it needs to be set as an expression, such as__count__> 3.
 */
public data class AlertConfigurationConditionConfiguration(
    public val condition: String? = null,
    public val countCondition: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfigurationConditionConfiguration): AlertConfigurationConditionConfiguration = AlertConfigurationConditionConfiguration(
            condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
            countCondition = javaType.countCondition().map({ args0 -> args0 }).orElse(null),
        )
    }
}
