@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionPolicyId The ID of the action policy used. If the alert policy is in advanced mode and the selected alert policy is not configured with a dynamic action policy, set the actionPolicyId to an empty string.
 * @property alertPolicyId Alarm policy ID. If it is in simple mode or normal mode, set it to sls.builtin.dynamic (dynamic alarm policy built into the system). For advanced mode, set it to the specified alarm policy ID.
 * @property repeatInterval Repeat the waiting time. For example, 5m, 1H, etc.
 */
public data class AlertConfigurationPolicyConfiguration(
    public val actionPolicyId: String? = null,
    public val alertPolicyId: String? = null,
    public val repeatInterval: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfigurationPolicyConfiguration): AlertConfigurationPolicyConfiguration = AlertConfigurationPolicyConfiguration(
            actionPolicyId = javaType.actionPolicyId().map({ args0 -> args0 }).orElse(null),
            alertPolicyId = javaType.alertPolicyId().map({ args0 -> args0 }).orElse(null),
            repeatInterval = javaType.repeatInterval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
