@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property chartTitle Chart Name.
 * @property dashboardId Dashboard ID.
 * @property end End time. When storeType is set to log or metric, end must be set.
 * @property powerSqlMode Whether to use exclusive SQL. The value is as follows: auto: automatic switching. enable: Starts. disable: disable.
 * @property project Project Name.
 * @property query Query and analysis statements. When storeType is set to log or metric, query is set to the query analysis statement. When storeType is set to meta, set query to an empty string.
 * @property region Region of the target Project.
 * @property roleArn Roles used to write alarm data to the event Library.
 * @property start Start time. When storeType is set to log or metric, start must be set.
 * @property store Query the Logstore, Metricstore, or resource data associated with the statistics. When storeType is set to log, store is set to the target Logstore. When storeType is set to metric, store is set to the target Metricstore. When storeType is set to meta, store is set to the target resource data name.
 * @property storeType Query the data source type. The value is as follows: log: Logstore. metric: Time series Library. meta: resource data.
 * @property timeSpanType Time Type.
 * @property ui Use of specific scene alarm front end.
 */
public data class AlertConfigurationQueryList(
    public val chartTitle: String? = null,
    public val dashboardId: String? = null,
    public val end: String? = null,
    public val powerSqlMode: String? = null,
    public val project: String? = null,
    public val query: String? = null,
    public val region: String? = null,
    public val roleArn: String? = null,
    public val start: String? = null,
    public val store: String? = null,
    public val storeType: String? = null,
    public val timeSpanType: String? = null,
    public val ui: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfigurationQueryList): AlertConfigurationQueryList = AlertConfigurationQueryList(
            chartTitle = javaType.chartTitle().map({ args0 -> args0 }).orElse(null),
            dashboardId = javaType.dashboardId().map({ args0 -> args0 }).orElse(null),
            end = javaType.end().map({ args0 -> args0 }).orElse(null),
            powerSqlMode = javaType.powerSqlMode().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            start = javaType.start().map({ args0 -> args0 }).orElse(null),
            store = javaType.store().map({ args0 -> args0 }).orElse(null),
            storeType = javaType.storeType().map({ args0 -> args0 }).orElse(null),
            timeSpanType = javaType.timeSpanType().map({ args0 -> args0 }).orElse(null),
            ui = javaType.ui().map({ args0 -> args0 }).orElse(null),
        )
    }
}
