@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Open.
 * @property endpoint SLS service endpoint.
 * @property eventStore Event Library Name.
 * @property project Project Name.
 * @property roleArn Roles used to write alarm data to the event Library.
 */
public data class AlertConfigurationSinkEventStore(
    public val enabled: Boolean? = null,
    public val endpoint: String? = null,
    public val eventStore: String? = null,
    public val project: String? = null,
    public val roleArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfigurationSinkEventStore): AlertConfigurationSinkEventStore = AlertConfigurationSinkEventStore(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            eventStore = javaType.eventStore().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
