@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property annotations Template Annotations.
 * @property lang Template Language.
 * @property templateId Template ID.
 * @property tokens Template Variables.
 * @property type
 * @property version Template Version.
 */
public data class AlertConfigurationTemplateConfiguration(
    public val annotations: Map<String, String>? = null,
    public val lang: String? = null,
    public val templateId: String? = null,
    public val tokens: Map<String, String>? = null,
    public val type: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertConfigurationTemplateConfiguration): AlertConfigurationTemplateConfiguration = AlertConfigurationTemplateConfiguration(
            annotations = javaType.annotations().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            tokens = javaType.tokens().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
