@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpression Cron expression, the minimum accuracy is minutes, 24 hours. For example, 0 0/1 * * * means that the check is conducted every 1 hour from 00:00. When type is set to Cron, cronExpression must be set.
 * @property delay Timed task execution delay (unit: s).
 * @property interval Fixed interval for scheduling.
 * @property runImmdiately Dispatch immediately.
 * @property timeZone The time zone where the Cron expression is located. The default value is null, indicating the eighth zone in the east.
 * @property type Check the frequency type. Log Service checks the query and analysis results according to the frequency you configured. The values are as follows: Fixedate: checks query and analysis results at regular intervals. Cron: specifies the time interval by using the Cron expression, and checks the query and analysis results at the specified time interval.
 */
public data class AlertSchedule(
    public val cronExpression: String? = null,
    public val delay: Int? = null,
    public val interval: String? = null,
    public val runImmdiately: Boolean? = null,
    public val timeZone: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.AlertSchedule): AlertSchedule =
            AlertSchedule(
                cronExpression = javaType.cronExpression().map({ args0 -> args0 }).orElse(null),
                delay = javaType.delay().map({ args0 -> args0 }).orElse(null),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                runImmdiately = javaType.runImmdiately().map({ args0 -> args0 }).orElse(null),
                timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
