@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpression Cron expression, minimum precision is minutes, 24-hour clock. For example, 0 0/1 **indicates that the check is performed every one hour from 00:00. When type is set to Cron, cronExpression must be set.
 * @property delay Delay time.
 * @property interval Time interval, such as 5m, 1H.
 * @property runImmediately Whether to execute the OSS import task immediately after it is created.
 * @property timeZone Time Zone.
 * @property type Check the frequency type. Log Service checks the query and analysis results based on the frequency you configured. The value is as follows: FixedRate: checks the query and analysis results at fixed intervals. Cron: specifies a time interval through a Cron expression, and checks the query and analysis results at the specified time interval. Weekly: Check the query and analysis results at a fixed point in time on the day of the week. Daily: checks the query and analysis results at a fixed time point every day. Hourly: Check query and analysis results every hour.
 */
public data class ScheduledSqlSchedule(
    public val cronExpression: String? = null,
    public val delay: Int? = null,
    public val interval: String? = null,
    public val runImmediately: Boolean? = null,
    public val timeZone: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.ScheduledSqlSchedule): ScheduledSqlSchedule = ScheduledSqlSchedule(
            cronExpression = javaType.cronExpression().map({ args0 -> args0 }).orElse(null),
            delay = javaType.delay().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            runImmediately = javaType.runImmediately().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
