@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sls.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dataFormat Write Mode.
 * @property destEndpoint Target Endpoint.
 * @property destLogstore Target Logstore.
 * @property destProject Target Project.
 * @property destRoleArn Write target role ARN.
 * @property fromTime Schedule Start Time.
 * @property fromTimeExpr SQL time window-start.
 * @property maxRetries Maximum retries.
 * @property maxRunTimeInSeconds SQL timeout.
 * @property parameters Parameter configuration.
 * @property resourcePool Resource Pool.
 * @property roleArn Read role ARN.
 * @property script SQL statement.
 * @property sourceLogstore Source Logstore.
 * @property sqlType SQL type.
 * @property toTime Time at end of schedule.
 * @property toTimeExpr SQL time window-end.
 */
public data class ScheduledSqlScheduledSqlConfiguration(
    public val dataFormat: String? = null,
    public val destEndpoint: String? = null,
    public val destLogstore: String? = null,
    public val destProject: String? = null,
    public val destRoleArn: String? = null,
    public val fromTime: Int? = null,
    public val fromTimeExpr: String? = null,
    public val maxRetries: Int? = null,
    public val maxRunTimeInSeconds: Int? = null,
    public val parameters: Map<String, String>? = null,
    public val resourcePool: String? = null,
    public val roleArn: String? = null,
    public val script: String? = null,
    public val sourceLogstore: String? = null,
    public val sqlType: String? = null,
    public val toTime: Int? = null,
    public val toTimeExpr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.sls.outputs.ScheduledSqlScheduledSqlConfiguration): ScheduledSqlScheduledSqlConfiguration = ScheduledSqlScheduledSqlConfiguration(
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            destEndpoint = javaType.destEndpoint().map({ args0 -> args0 }).orElse(null),
            destLogstore = javaType.destLogstore().map({ args0 -> args0 }).orElse(null),
            destProject = javaType.destProject().map({ args0 -> args0 }).orElse(null),
            destRoleArn = javaType.destRoleArn().map({ args0 -> args0 }).orElse(null),
            fromTime = javaType.fromTime().map({ args0 -> args0 }).orElse(null),
            fromTimeExpr = javaType.fromTimeExpr().map({ args0 -> args0 }).orElse(null),
            maxRetries = javaType.maxRetries().map({ args0 -> args0 }).orElse(null),
            maxRunTimeInSeconds = javaType.maxRunTimeInSeconds().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resourcePool = javaType.resourcePool().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
            sourceLogstore = javaType.sourceLogstore().map({ args0 -> args0 }).orElse(null),
            sqlType = javaType.sqlType().map({ args0 -> args0 }).orElse(null),
            toTime = javaType.toTime().map({ args0 -> args0 }).orElse(null),
            toTimeExpr = javaType.toTimeExpr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
