@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ShortUrl].
 */
@PulumiTagMarker
public class ShortUrlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ShortUrlArgs = ShortUrlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ShortUrlArgsBuilder.() -> Unit) {
        val builder = ShortUrlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ShortUrl {
        val builtJavaResource = com.pulumi.alicloud.sms.ShortUrl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ShortUrl(builtJavaResource)
    }
}

/**
 * Provides a SMS Short Url resource.
 * For information about SMS Short Url and how to use it, see [What is Short Url](https://next.api.alibabacloud.com/api/Dysmsapi/2017-05-25/AddShortUrl).
 * > **NOTE:** Available in v1.178.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.sms.ShortUrl("example", {
 *     effectiveDays: 30,
 *     shortUrlName: "example_value",
 *     sourceUrl: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.sms.ShortUrl("example",
 *     effective_days=30,
 *     short_url_name="example_value",
 *     source_url="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Sms.ShortUrl("example", new()
 *     {
 *         EffectiveDays = 30,
 *         ShortUrlName = "example_value",
 *         SourceUrl = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sms.NewShortUrl(ctx, "example", &sms.ShortUrlArgs{
 * 			EffectiveDays: pulumi.Int(30),
 * 			ShortUrlName:  pulumi.String("example_value"),
 * 			SourceUrl:     pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sms.ShortUrl;
 * import com.pulumi.alicloud.sms.ShortUrlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ShortUrl("example", ShortUrlArgs.builder()
 *             .effectiveDays(30)
 *             .shortUrlName("example_value")
 *             .sourceUrl("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:sms:ShortUrl
 *     properties:
 *       effectiveDays: 30
 *       shortUrlName: example_value
 *       sourceUrl: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SMS Short Url can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sms/shortUrl:ShortUrl example <id>
 * ```
 */
public class ShortUrl internal constructor(
    override val javaResource: com.pulumi.alicloud.sms.ShortUrl,
) : KotlinCustomResource(javaResource, ShortUrlMapper) {
    /**
     * Short chain service use validity period. Valid values: `30`, `60`, `90`. The unit is days, and the maximum validity period is 90 days.
     */
    public val effectiveDays: Output<Int>
        get() = javaResource.effectiveDays().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val shortUrlName: Output<String>
        get() = javaResource.shortUrlName().applyValue({ args0 -> args0 })

    /**
     * The original link address.
     */
    public val sourceUrl: Output<String>
        get() = javaResource.sourceUrl().applyValue({ args0 -> args0 })

    /**
     * Short chain status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ShortUrlMapper : ResourceMapper<ShortUrl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sms.ShortUrl::class == javaResource::class

    override fun map(javaResource: Resource): ShortUrl = ShortUrl(
        javaResource as
            com.pulumi.alicloud.sms.ShortUrl,
    )
}

/**
 * @see [ShortUrl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ShortUrl].
 */
public suspend fun shortUrl(name: String, block: suspend ShortUrlResourceBuilder.() -> Unit): ShortUrl {
    val builder = ShortUrlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ShortUrl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun shortUrl(name: String): ShortUrl {
    val builder = ShortUrlResourceBuilder()
    builder.name(name)
    return builder.build()
}
