@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sms.kotlin

import com.pulumi.alicloud.sms.ShortUrlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SMS Short Url resource.
 * For information about SMS Short Url and how to use it, see [What is Short Url](https://next.api.alibabacloud.com/api/Dysmsapi/2017-05-25/AddShortUrl).
 * > **NOTE:** Available in v1.178.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.sms.ShortUrl("example", {
 *     effectiveDays: 30,
 *     shortUrlName: "example_value",
 *     sourceUrl: "example_value",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.sms.ShortUrl("example",
 *     effective_days=30,
 *     short_url_name="example_value",
 *     source_url="example_value")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Sms.ShortUrl("example", new()
 *     {
 *         EffectiveDays = 30,
 *         ShortUrlName = "example_value",
 *         SourceUrl = "example_value",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sms.NewShortUrl(ctx, "example", &sms.ShortUrlArgs{
 * 			EffectiveDays: pulumi.Int(30),
 * 			ShortUrlName:  pulumi.String("example_value"),
 * 			SourceUrl:     pulumi.String("example_value"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.sms.ShortUrl;
 * import com.pulumi.alicloud.sms.ShortUrlArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ShortUrl("example", ShortUrlArgs.builder()
 *             .effectiveDays(30)
 *             .shortUrlName("example_value")
 *             .sourceUrl("example_value")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:sms:ShortUrl
 *     properties:
 *       effectiveDays: 30
 *       shortUrlName: example_value
 *       sourceUrl: example_value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * SMS Short Url can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sms/shortUrl:ShortUrl example <id>
 * ```
 * @property effectiveDays Short chain service use validity period. Valid values: `30`, `60`, `90`. The unit is days, and the maximum validity period is 90 days.
 * @property shortUrlName The name of the resource.
 * @property sourceUrl The original link address.
 */
public data class ShortUrlArgs(
    public val effectiveDays: Output<Int>? = null,
    public val shortUrlName: Output<String>? = null,
    public val sourceUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sms.ShortUrlArgs> {
    override fun toJava(): com.pulumi.alicloud.sms.ShortUrlArgs =
        com.pulumi.alicloud.sms.ShortUrlArgs.builder()
            .effectiveDays(effectiveDays?.applyValue({ args0 -> args0 }))
            .shortUrlName(shortUrlName?.applyValue({ args0 -> args0 }))
            .sourceUrl(sourceUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ShortUrlArgs].
 */
@PulumiTagMarker
public class ShortUrlArgsBuilder internal constructor() {
    private var effectiveDays: Output<Int>? = null

    private var shortUrlName: Output<String>? = null

    private var sourceUrl: Output<String>? = null

    /**
     * @param value Short chain service use validity period. Valid values: `30`, `60`, `90`. The unit is days, and the maximum validity period is 90 days.
     */
    @JvmName("ssjjrlwxbjklhafr")
    public suspend fun effectiveDays(`value`: Output<Int>) {
        this.effectiveDays = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("aeugocqwussxlkwt")
    public suspend fun shortUrlName(`value`: Output<String>) {
        this.shortUrlName = value
    }

    /**
     * @param value The original link address.
     */
    @JvmName("hsuoosnxfhtcrcbj")
    public suspend fun sourceUrl(`value`: Output<String>) {
        this.sourceUrl = value
    }

    /**
     * @param value Short chain service use validity period. Valid values: `30`, `60`, `90`. The unit is days, and the maximum validity period is 90 days.
     */
    @JvmName("qrlgmcsxupxkvsfc")
    public suspend fun effectiveDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveDays = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("pbrrapocecyxhlsd")
    public suspend fun shortUrlName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortUrlName = mapped
    }

    /**
     * @param value The original link address.
     */
    @JvmName("fpogkgtvljstdvuo")
    public suspend fun sourceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceUrl = mapped
    }

    internal fun build(): ShortUrlArgs = ShortUrlArgs(
        effectiveDays = effectiveDays,
        shortUrlName = shortUrlName,
        sourceUrl = sourceUrl,
    )
}
