@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MetaTag].
 */
@PulumiTagMarker
public class MetaTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetaTagArgs = MetaTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetaTagArgsBuilder.() -> Unit) {
        val builder = MetaTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetaTag {
        val builtJavaResource = com.pulumi.alicloud.tag.MetaTag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MetaTag(builtJavaResource)
    }
}

/**
 * Provides a Tag Meta Tag resource.
 * For information about Tag Meta Tag and how to use it,
 * see [What is Meta Tag](https://www.alibabacloud.com/help/en/resource-management/latest/createtags).
 * > **NOTE:** Available since v1.209.0.
 * > **NOTE:** Meta Tag Only Support `cn-hangzhou` Region
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.tag.MetaTag("example", {
 *     key: "Name1",
 *     values: ["Desc2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.tag.MetaTag("example",
 *     key="Name1",
 *     values=["Desc2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Tag.MetaTag("example", new()
 *     {
 *         Key = "Name1",
 *         Values = new[]
 *         {
 *             "Desc2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tag"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := tag.NewMetaTag(ctx, "example", &tag.MetaTagArgs{
 * 			Key: pulumi.String("Name1"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("Desc2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.tag.MetaTag;
 * import com.pulumi.alicloud.tag.MetaTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MetaTag("example", MetaTagArgs.builder()
 *             .key("Name1")
 *             .values("Desc2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:tag:MetaTag
 *     properties:
 *       key: Name1
 *       values:
 *         - Desc2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Tag Meta Tag can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:tag/metaTag:MetaTag example <regionId>:<key>
 * ```
 */
public class MetaTag internal constructor(
    override val javaResource: com.pulumi.alicloud.tag.MetaTag,
) : KotlinCustomResource(javaResource, MetaTagMapper) {
    /**
     * The key of the tag meta tag. key must be 1 to 128 characters in length.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The values of the tag meta tag.
     */
    public val values: Output<List<String>>
        get() = javaResource.values().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object MetaTagMapper : ResourceMapper<MetaTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.tag.MetaTag::class == javaResource::class

    override fun map(javaResource: Resource): MetaTag = MetaTag(
        javaResource as
            com.pulumi.alicloud.tag.MetaTag,
    )
}

/**
 * @see [MetaTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetaTag].
 */
public suspend fun metaTag(name: String, block: suspend MetaTagResourceBuilder.() -> Unit): MetaTag {
    val builder = MetaTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetaTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metaTag(name: String): MetaTag {
    val builder = MetaTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
