@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin

import com.pulumi.alicloud.tag.MetaTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Tag Meta Tag resource.
 * For information about Tag Meta Tag and how to use it,
 * see [What is Meta Tag](https://www.alibabacloud.com/help/en/resource-management/latest/createtags).
 * > **NOTE:** Available since v1.209.0.
 * > **NOTE:** Meta Tag Only Support `cn-hangzhou` Region
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.tag.MetaTag("example", {
 *     key: "Name1",
 *     values: ["Desc2"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.tag.MetaTag("example",
 *     key="Name1",
 *     values=["Desc2"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Tag.MetaTag("example", new()
 *     {
 *         Key = "Name1",
 *         Values = new[]
 *         {
 *             "Desc2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tag"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := tag.NewMetaTag(ctx, "example", &tag.MetaTagArgs{
 * 			Key: pulumi.String("Name1"),
 * 			Values: pulumi.StringArray{
 * 				pulumi.String("Desc2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.tag.MetaTag;
 * import com.pulumi.alicloud.tag.MetaTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MetaTag("example", MetaTagArgs.builder()
 *             .key("Name1")
 *             .values("Desc2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:tag:MetaTag
 *     properties:
 *       key: Name1
 *       values:
 *         - Desc2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Tag Meta Tag can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:tag/metaTag:MetaTag example <regionId>:<key>
 * ```
 * @property key The key of the tag meta tag. key must be 1 to 128 characters in length.
 * @property values The values of the tag meta tag.
 */
public data class MetaTagArgs(
    public val key: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.tag.MetaTagArgs> {
    override fun toJava(): com.pulumi.alicloud.tag.MetaTagArgs =
        com.pulumi.alicloud.tag.MetaTagArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MetaTagArgs].
 */
@PulumiTagMarker
public class MetaTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The key of the tag meta tag. key must be 1 to 128 characters in length.
     */
    @JvmName("tuxgynssfqvnhjuw")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The values of the tag meta tag.
     */
    @JvmName("yurhvbqqqhiqhdwb")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("lrajahfegydqraii")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The values of the tag meta tag.
     */
    @JvmName("kwsutylkcavrxter")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The key of the tag meta tag. key must be 1 to 128 characters in length.
     */
    @JvmName("rvyvwvryigjvbfnw")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The values of the tag meta tag.
     */
    @JvmName("ytrvynhryxwdqkys")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The values of the tag meta tag.
     */
    @JvmName("lptgorfcgaveawkb")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): MetaTagArgs = MetaTagArgs(
        key = key,
        values = values,
    )
}
