@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin

import com.pulumi.alicloud.tag.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Tag Policy resource.
 * For information about Tag Policy and how to use it,
 * see [What is Policy](https://www.alibabacloud.com/help/en/resource-management/latest/create-policy).
 * > **NOTE:** Available since v1.203.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.tag.Policy("example", {
 *     policyName: name,
 *     policyDesc: name,
 *     userType: "USER",
 *     policyContent: "\x09\x09{\"tags\":{\"CostCenter\":{\"tag_value\":{\"@@assign\":[\"Beijing\",\"Shanghai\"]},\"tag_key\":{\"@@assign\":\"CostCenter\"}}}}\n",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.tag.Policy("example",
 *     policy_name=name,
 *     policy_desc=name,
 *     user_type="USER",
 *     policy_content="\x09\x09{\"tags\":{\"CostCenter\":{\"tag_value\":{\"@@assign\":[\"Beijing\",\"Shanghai\"]},\"tag_key\":{\"@@assign\":\"CostCenter\"}}}}\n")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.Tag.Policy("example", new()
 *     {
 *         PolicyName = name,
 *         PolicyDesc = name,
 *         UserType = "USER",
 *         PolicyContent = @"		{""tags"":{""CostCenter"":{""tag_value"":{""@@assign"":[""Beijing"",""Shanghai""]},""tag_key"":{""@@assign"":""CostCenter""}}}}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tag"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := tag.NewPolicy(ctx, "example", &tag.PolicyArgs{
 * 			PolicyName:    pulumi.String(name),
 * 			PolicyDesc:    pulumi.String(name),
 * 			UserType:      pulumi.String("USER"),
 * 			PolicyContent: pulumi.String("		{\"tags\":{\"CostCenter\":{\"tag_value\":{\"@@assign\":[\"Beijing\",\"Shanghai\"]},\"tag_key\":{\"@@assign\":\"CostCenter\"}}}}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.tag.Policy;
 * import com.pulumi.alicloud.tag.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyName(name)
 *             .policyDesc(name)
 *             .userType("USER")
 *             .policyContent("""
 * 		{"tags":{"CostCenter":{"tag_value":{"@@assign":["Beijing","Shanghai"]},"tag_key":{"@@assign":"CostCenter"}}}}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:tag:Policy
 *     properties:
 *       policyName: ${name}
 *       policyDesc: ${name}
 *       userType: USER
 *       policyContent: |
 *         		{"tags":{"CostCenter":{"tag_value":{"@@assign":["Beijing","Shanghai"]},"tag_key":{"@@assign":"CostCenter"}}}}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Tag Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:tag/policy:Policy example <id>
 * ```
 * @property policyContent The content of the policy.
 * @property policyDesc The description of the policy. The description must be 1 to 512 characters in length.
 * @property policyName The name of the policy. name must be 1 to 128 characters in length and can contain letters,
 * digits, and hyphens (-).
 * @property userType The type of the tag policy. Valid values: `USER`, `RD`.
 */
public data class PolicyArgs(
    public val policyContent: Output<String>? = null,
    public val policyDesc: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val userType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.tag.PolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.tag.PolicyArgs =
        com.pulumi.alicloud.tag.PolicyArgs.builder()
            .policyContent(policyContent?.applyValue({ args0 -> args0 }))
            .policyDesc(policyDesc?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .userType(userType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var policyContent: Output<String>? = null

    private var policyDesc: Output<String>? = null

    private var policyName: Output<String>? = null

    private var userType: Output<String>? = null

    /**
     * @param value The content of the policy.
     */
    @JvmName("nvninrtdxcmmjvph")
    public suspend fun policyContent(`value`: Output<String>) {
        this.policyContent = value
    }

    /**
     * @param value The description of the policy. The description must be 1 to 512 characters in length.
     */
    @JvmName("anfoxhwusmsocbes")
    public suspend fun policyDesc(`value`: Output<String>) {
        this.policyDesc = value
    }

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters,
     * digits, and hyphens (-).
     */
    @JvmName("bqoirbejvjwdohkf")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The type of the tag policy. Valid values: `USER`, `RD`.
     */
    @JvmName("lvgqpidfwopryopy")
    public suspend fun userType(`value`: Output<String>) {
        this.userType = value
    }

    /**
     * @param value The content of the policy.
     */
    @JvmName("uljwnjljrtupreig")
    public suspend fun policyContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyContent = mapped
    }

    /**
     * @param value The description of the policy. The description must be 1 to 512 characters in length.
     */
    @JvmName("aavrqhnoagpywdhu")
    public suspend fun policyDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDesc = mapped
    }

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters,
     * digits, and hyphens (-).
     */
    @JvmName("scqpcdxnpxxsvnlo")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The type of the tag policy. Valid values: `USER`, `RD`.
     */
    @JvmName("wkiqyxwgoorsbmdh")
    public suspend fun userType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        policyContent = policyContent,
        policyDesc = policyDesc,
        policyName = policyName,
        userType = userType,
    )
}
