@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin

import com.pulumi.alicloud.tag.TagFunctions.getMetaTagsPlain
import com.pulumi.alicloud.tag.kotlin.inputs.GetMetaTagsPlainArgs
import com.pulumi.alicloud.tag.kotlin.inputs.GetMetaTagsPlainArgsBuilder
import com.pulumi.alicloud.tag.kotlin.outputs.GetMetaTagsResult
import com.pulumi.alicloud.tag.kotlin.outputs.GetMetaTagsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object TagFunctions {
    /**
     * This data source provides the Tag Meta Tags of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.169.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.tag.getMetaTags({
     *     keyName: "example_value",
     * });
     * export const tagMetaTagDefault1 = _default.then(_default => _default.tags?.valueName);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.tag.get_meta_tags(key_name="example_value")
     * pulumi.export("tagMetaTagDefault1", default.tags.value_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Tag.GetMetaTags.Invoke(new()
     *     {
     *         KeyName = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["tagMetaTagDefault1"] = @default.Apply(@default => @default.Apply(getMetaTagsResult => getMetaTagsResult.Tags?.ValueName)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tag"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := tag.GetMetaTags(ctx, &tag.GetMetaTagsArgs{
     * 			KeyName: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("tagMetaTagDefault1", _default.Tags.ValueName)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.tag.TagFunctions;
     * import com.pulumi.alicloud.tag.inputs.GetMetaTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = TagFunctions.getMetaTags(GetMetaTagsArgs.builder()
     *             .keyName("example_value")
     *             .build());
     *         ctx.export("tagMetaTagDefault1", default_.tags().valueName());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:tag:getMetaTags
     *       Arguments:
     *         keyName: example_value
     * outputs:
     *   tagMetaTagDefault1: ${default.tags.valueName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getMetaTags.
     * @return A collection of values returned by getMetaTags.
     */
    public suspend fun getMetaTags(argument: GetMetaTagsPlainArgs): GetMetaTagsResult =
        toKotlin(getMetaTagsPlain(argument.toJava()).await())

    /**
     * @see [getMetaTags].
     * @param keyName The name of the key.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getMetaTags.
     */
    public suspend fun getMetaTags(keyName: String? = null, outputFile: String? = null): GetMetaTagsResult {
        val argument = GetMetaTagsPlainArgs(
            keyName = keyName,
            outputFile = outputFile,
        )
        return toKotlin(getMetaTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetaTags].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;tag&#46;kotlin&#46;inputs&#46;GetMetaTagsPlainArgs].
     * @return A collection of values returned by getMetaTags.
     */
    public suspend fun getMetaTags(argument: suspend GetMetaTagsPlainArgsBuilder.() -> Unit): GetMetaTagsResult {
        val builder = GetMetaTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getMetaTagsPlain(builtArgument.toJava()).await())
    }
}
