@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin.inputs

import com.pulumi.alicloud.tag.inputs.GetMetaTagsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMetaTags.
 * @property keyName The name of the key.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetMetaTagsPlainArgs(
    public val keyName: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.tag.inputs.GetMetaTagsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.tag.inputs.GetMetaTagsPlainArgs =
        com.pulumi.alicloud.tag.inputs.GetMetaTagsPlainArgs.builder()
            .keyName(keyName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetaTagsPlainArgs].
 */
@PulumiTagMarker
public class GetMetaTagsPlainArgsBuilder internal constructor() {
    private var keyName: String? = null

    private var outputFile: String? = null

    /**
     * @param value The name of the key.
     */
    @JvmName("nbkifjixsqkrskst")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xyyngpxektrnmlrw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetMetaTagsPlainArgs = GetMetaTagsPlainArgs(
        keyName = keyName,
        outputFile = outputFile,
    )
}
