@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMetaTags.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyName
 * @property outputFile
 * @property tags
 */
public data class GetMetaTagsResult(
    public val id: String,
    public val keyName: String? = null,
    public val outputFile: String? = null,
    public val tags: List<GetMetaTagsTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.tag.outputs.GetMetaTagsResult): GetMetaTagsResult = GetMetaTagsResult(
            id = javaType.id(),
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.tag.kotlin.outputs.GetMetaTagsTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
