@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tag.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The type of the resource tags.
 * @property keyName The name of the key.
 * @property valueName The name of the value.
 */
public data class GetMetaTagsTag(
    public val category: String,
    public val keyName: String,
    public val valueName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.tag.outputs.GetMetaTagsTag): GetMetaTagsTag =
            GetMetaTagsTag(
                category = javaType.category(),
                keyName = javaType.keyName(),
                valueName = javaType.valueName(),
            )
    }
}
