@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AntiBruteForceRule].
 */
@PulumiTagMarker
public class AntiBruteForceRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AntiBruteForceRuleArgs = AntiBruteForceRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AntiBruteForceRuleArgsBuilder.() -> Unit) {
        val builder = AntiBruteForceRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AntiBruteForceRule {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.AntiBruteForceRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AntiBruteForceRule(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Anti Brute Force Rule resource.
 * For information about Threat Detection Anti Brute Force Rule and how to use it, see [What is Anti Brute Force Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createantibruteforcerule).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.AntiBruteForceRule("default", {
 *     antiBruteForceRuleName: "apispec_example",
 *     forbiddenTime: 360,
 *     uuidLists: ["032b618f-b220-4a0d-bd37-fbdc6ef58b6a"],
 *     failCount: 80,
 *     span: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.AntiBruteForceRule("default",
 *     anti_brute_force_rule_name="apispec_example",
 *     forbidden_time=360,
 *     uuid_lists=["032b618f-b220-4a0d-bd37-fbdc6ef58b6a"],
 *     fail_count=80,
 *     span=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.AntiBruteForceRule("default", new()
 *     {
 *         AntiBruteForceRuleName = "apispec_example",
 *         ForbiddenTime = 360,
 *         UuidLists = new[]
 *         {
 *             "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *         },
 *         FailCount = 80,
 *         Span = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewAntiBruteForceRule(ctx, "default", &threatdetection.AntiBruteForceRuleArgs{
 * 			AntiBruteForceRuleName: pulumi.String("apispec_example"),
 * 			ForbiddenTime:          pulumi.Int(360),
 * 			UuidLists: pulumi.StringArray{
 * 				pulumi.String("032b618f-b220-4a0d-bd37-fbdc6ef58b6a"),
 * 			},
 * 			FailCount: pulumi.Int(80),
 * 			Span:      pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.AntiBruteForceRule;
 * import com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AntiBruteForceRule("default", AntiBruteForceRuleArgs.builder()
 *             .antiBruteForceRuleName("apispec_example")
 *             .forbiddenTime(360)
 *             .uuidLists("032b618f-b220-4a0d-bd37-fbdc6ef58b6a")
 *             .failCount(80)
 *             .span(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:AntiBruteForceRule
 *     properties:
 *       antiBruteForceRuleName: apispec_example
 *       forbiddenTime: 360
 *       uuidLists:
 *         - 032b618f-b220-4a0d-bd37-fbdc6ef58b6a
 *       failCount: 80
 *       span: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Anti Brute Force Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/antiBruteForceRule:AntiBruteForceRule example <id>
 * ```
 */
public class AntiBruteForceRule internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.AntiBruteForceRule,
) : KotlinCustomResource(javaResource, AntiBruteForceRuleMapper) {
    /**
     * The ID of the defense rule.
     */
    public val antiBruteForceRuleId: Output<String>
        get() = javaResource.antiBruteForceRuleId().applyValue({ args0 -> args0 })

    /**
     * The name of the defense rule.
     */
    public val antiBruteForceRuleName: Output<String>
        get() = javaResource.antiBruteForceRuleName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to set the defense rule as the default rule.
     */
    public val defaultRule: Output<Boolean>
        get() = javaResource.defaultRule().applyValue({ args0 -> args0 })

    /**
     * The threshold for the number of failed user logins when the brute-force defense rule takes effect.
     */
    public val failCount: Output<Int>
        get() = javaResource.failCount().applyValue({ args0 -> args0 })

    /**
     * The period of time during which logons from an account are not allowed. Unit: minutes.
     */
    public val forbiddenTime: Output<Int>
        get() = javaResource.forbiddenTime().applyValue({ args0 -> args0 })

    /**
     * The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
     */
    public val span: Output<Int>
        get() = javaResource.span().applyValue({ args0 -> args0 })

    /**
     * An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
     */
    public val uuidLists: Output<List<String>>
        get() = javaResource.uuidLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object AntiBruteForceRuleMapper : ResourceMapper<AntiBruteForceRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.AntiBruteForceRule::class == javaResource::class

    override fun map(javaResource: Resource): AntiBruteForceRule = AntiBruteForceRule(
        javaResource as
            com.pulumi.alicloud.threatdetection.AntiBruteForceRule,
    )
}

/**
 * @see [AntiBruteForceRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AntiBruteForceRule].
 */
public suspend fun antiBruteForceRule(
    name: String,
    block: suspend AntiBruteForceRuleResourceBuilder.() -> Unit,
): AntiBruteForceRule {
    val builder = AntiBruteForceRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AntiBruteForceRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun antiBruteForceRule(name: String): AntiBruteForceRule {
    val builder = AntiBruteForceRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
