@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Anti Brute Force Rule resource.
 * For information about Threat Detection Anti Brute Force Rule and how to use it, see [What is Anti Brute Force Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createantibruteforcerule).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.AntiBruteForceRule("default", {
 *     antiBruteForceRuleName: "apispec_example",
 *     forbiddenTime: 360,
 *     uuidLists: ["032b618f-b220-4a0d-bd37-fbdc6ef58b6a"],
 *     failCount: 80,
 *     span: 10,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.AntiBruteForceRule("default",
 *     anti_brute_force_rule_name="apispec_example",
 *     forbidden_time=360,
 *     uuid_lists=["032b618f-b220-4a0d-bd37-fbdc6ef58b6a"],
 *     fail_count=80,
 *     span=10)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.AntiBruteForceRule("default", new()
 *     {
 *         AntiBruteForceRuleName = "apispec_example",
 *         ForbiddenTime = 360,
 *         UuidLists = new[]
 *         {
 *             "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *         },
 *         FailCount = 80,
 *         Span = 10,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewAntiBruteForceRule(ctx, "default", &threatdetection.AntiBruteForceRuleArgs{
 * 			AntiBruteForceRuleName: pulumi.String("apispec_example"),
 * 			ForbiddenTime:          pulumi.Int(360),
 * 			UuidLists: pulumi.StringArray{
 * 				pulumi.String("032b618f-b220-4a0d-bd37-fbdc6ef58b6a"),
 * 			},
 * 			FailCount: pulumi.Int(80),
 * 			Span:      pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.AntiBruteForceRule;
 * import com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new AntiBruteForceRule("default", AntiBruteForceRuleArgs.builder()
 *             .antiBruteForceRuleName("apispec_example")
 *             .forbiddenTime(360)
 *             .uuidLists("032b618f-b220-4a0d-bd37-fbdc6ef58b6a")
 *             .failCount(80)
 *             .span(10)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:AntiBruteForceRule
 *     properties:
 *       antiBruteForceRuleName: apispec_example
 *       forbiddenTime: 360
 *       uuidLists:
 *         - 032b618f-b220-4a0d-bd37-fbdc6ef58b6a
 *       failCount: 80
 *       span: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Anti Brute Force Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/antiBruteForceRule:AntiBruteForceRule example <id>
 * ```
 * @property antiBruteForceRuleName The name of the defense rule.
 * @property defaultRule Specifies whether to set the defense rule as the default rule.
 * @property failCount The threshold for the number of failed user logins when the brute-force defense rule takes effect.
 * @property forbiddenTime The period of time during which logons from an account are not allowed. Unit: minutes.
 * @property span The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
 * @property uuidLists An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
 */
public data class AntiBruteForceRuleArgs(
    public val antiBruteForceRuleName: Output<String>? = null,
    public val defaultRule: Output<Boolean>? = null,
    public val failCount: Output<Int>? = null,
    public val forbiddenTime: Output<Int>? = null,
    public val span: Output<Int>? = null,
    public val uuidLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs =
        com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs.builder()
            .antiBruteForceRuleName(antiBruteForceRuleName?.applyValue({ args0 -> args0 }))
            .defaultRule(defaultRule?.applyValue({ args0 -> args0 }))
            .failCount(failCount?.applyValue({ args0 -> args0 }))
            .forbiddenTime(forbiddenTime?.applyValue({ args0 -> args0 }))
            .span(span?.applyValue({ args0 -> args0 }))
            .uuidLists(uuidLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AntiBruteForceRuleArgs].
 */
@PulumiTagMarker
public class AntiBruteForceRuleArgsBuilder internal constructor() {
    private var antiBruteForceRuleName: Output<String>? = null

    private var defaultRule: Output<Boolean>? = null

    private var failCount: Output<Int>? = null

    private var forbiddenTime: Output<Int>? = null

    private var span: Output<Int>? = null

    private var uuidLists: Output<List<String>>? = null

    /**
     * @param value The name of the defense rule.
     */
    @JvmName("kossehinmhegjbxi")
    public suspend fun antiBruteForceRuleName(`value`: Output<String>) {
        this.antiBruteForceRuleName = value
    }

    /**
     * @param value Specifies whether to set the defense rule as the default rule.
     */
    @JvmName("xgwbasebbympjoyk")
    public suspend fun defaultRule(`value`: Output<Boolean>) {
        this.defaultRule = value
    }

    /**
     * @param value The threshold for the number of failed user logins when the brute-force defense rule takes effect.
     */
    @JvmName("qhnnmmnrbxthnywy")
    public suspend fun failCount(`value`: Output<Int>) {
        this.failCount = value
    }

    /**
     * @param value The period of time during which logons from an account are not allowed. Unit: minutes.
     */
    @JvmName("efjjclmlhbffxodi")
    public suspend fun forbiddenTime(`value`: Output<Int>) {
        this.forbiddenTime = value
    }

    /**
     * @param value The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
     */
    @JvmName("xbbiqkcfxsgdvwsb")
    public suspend fun span(`value`: Output<Int>) {
        this.span = value
    }

    /**
     * @param value An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
     */
    @JvmName("srtslvqvmfnlgtbt")
    public suspend fun uuidLists(`value`: Output<List<String>>) {
        this.uuidLists = value
    }

    @JvmName("odcibmyvwdyiqujw")
    public suspend fun uuidLists(vararg values: Output<String>) {
        this.uuidLists = Output.all(values.asList())
    }

    /**
     * @param values An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
     */
    @JvmName("cbocwtbsapmqillj")
    public suspend fun uuidLists(values: List<Output<String>>) {
        this.uuidLists = Output.all(values)
    }

    /**
     * @param value The name of the defense rule.
     */
    @JvmName("qbclwacqsqxolami")
    public suspend fun antiBruteForceRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.antiBruteForceRuleName = mapped
    }

    /**
     * @param value Specifies whether to set the defense rule as the default rule.
     */
    @JvmName("atuhfnrkraxdmwcw")
    public suspend fun defaultRule(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRule = mapped
    }

    /**
     * @param value The threshold for the number of failed user logins when the brute-force defense rule takes effect.
     */
    @JvmName("bubdtqqdnvafpult")
    public suspend fun failCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failCount = mapped
    }

    /**
     * @param value The period of time during which logons from an account are not allowed. Unit: minutes.
     */
    @JvmName("qqiksgtabxrgutai")
    public suspend fun forbiddenTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forbiddenTime = mapped
    }

    /**
     * @param value The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
     */
    @JvmName("heopncrbypgswysw")
    public suspend fun span(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.span = mapped
    }

    /**
     * @param value An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
     */
    @JvmName("triaenugsgnesvxp")
    public suspend fun uuidLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuidLists = mapped
    }

    /**
     * @param values An array consisting of the UUIDs of servers to which the defense rule is applied.**The binding status must be Enterprise Edition.**
     */
    @JvmName("mkdtpnbvxoskvulu")
    public suspend fun uuidLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uuidLists = mapped
    }

    internal fun build(): AntiBruteForceRuleArgs = AntiBruteForceRuleArgs(
        antiBruteForceRuleName = antiBruteForceRuleName,
        defaultRule = defaultRule,
        failCount = failCount,
        forbiddenTime = forbiddenTime,
        span = span,
        uuidLists = uuidLists,
    )
}
