@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.BackupPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Backup Policy resource.
 * For information about Threat Detection Backup Policy and how to use it, see [What is Backup Policy](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.threatdetection.getAssets({
 *     machineTypes: "ecs",
 * });
 * const defaultBackupPolicy = new alicloud.threatdetection.BackupPolicy("default", {
 *     backupPolicyName: "tf-example-name",
 *     policy: "{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *     policyVersion: "2.0.0",
 *     uuidLists: [_default&#46;then(_default => _default&#46;ids?&#46;[0])],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.get_assets(machine_types="ecs")
 * default_backup_policy = alicloud.threatdetection.BackupPolicy("default",
 *     backup_policy_name="tf-example-name",
 *     policy="{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *     policy_version="2.0.0",
 *     uuid_lists=[default&#46;ids[0]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ThreatDetection.GetAssets.Invoke(new()
 *     {
 *         MachineTypes = "ecs",
 *     });
 *     var defaultBackupPolicy = new AliCloud.ThreatDetection.BackupPolicy("default", new()
 *     {
 *         BackupPolicyName = "tf-example-name",
 *         Policy = "{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *         PolicyVersion = "2.0.0",
 *         UuidLists = new[]
 *         {
 *             @default.Apply(@default => @default.Apply(getAssetsResult => getAssetsResult.Ids[0])),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := threatdetection.GetAssets(ctx, &threatdetection.GetAssetsArgs{
 * 			MachineTypes: pulumi.StringRef("ecs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewBackupPolicy(ctx, "default", &threatdetection.BackupPolicyArgs{
 * 			BackupPolicyName: pulumi.String("tf-example-name"),
 * 			Policy:           pulumi.String("{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}"),
 * 			PolicyVersion:    pulumi.String("2.0.0"),
 * 			UuidLists: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[0]),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetAssetsArgs;
 * import com.pulumi.alicloud.threatdetection.BackupPolicy;
 * import com.pulumi.alicloud.threatdetection.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ThreatdetectionFunctions.getAssets(GetAssetsArgs.builder()
 *             .machineTypes("ecs")
 *             .build());
 *         var defaultBackupPolicy = new BackupPolicy("defaultBackupPolicy", BackupPolicyArgs.builder()
 *             .backupPolicyName("tf-example-name")
 *             .policy("{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}")
 *             .policyVersion("2.0.0")
 *             .uuidLists(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultBackupPolicy:
 *     type: alicloud:threatdetection:BackupPolicy
 *     name: default
 *     properties:
 *       backupPolicyName: tf-example-name
 *       policy: '{"Exclude":["/bin/","/usr/bin/","/sbin/","/boot/","/proc/","/sys/","/srv/","/lib/","/selinux/","/usr/sbin/","/run/","/lib32/","/lib64/","/lost+found/","/var/lib/kubelet/","/var/lib/ntp/proc","/var/lib/container"],"ExcludeSystemPath":true,"Include":[],"IsDefault":1,"Retention":7,"Schedule":"I|1668703620|PT24H","Source":[],"SpeedLimiter":"","UseVss":true}'
 *       policyVersion: 2.0.0
 *       uuidLists:
 *         - ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getAssets
 *       Arguments:
 *         machineTypes: ecs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Backup Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/backupPolicy:BackupPolicy example <id>
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Protection of the Name of the Policy.
     */
    public val backupPolicyName: Output<String>
        get() = javaResource.backupPolicyName().applyValue({ args0 -> args0 })

    /**
     * The Specified Protection Policies of the Specific Configuration. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The region ID of the non-Alibaba cloud server. You can call the [DescribeSupportRegion](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describesupportregion) interface to view the region supported by anti-ransomware, and then select the region supported by anti-ransomware according to the region where your non-Alibaba cloud server is located.
     */
    public val policyRegionId: Output<String>?
        get() = javaResource.policyRegionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Anti-Blackmail Policy Version. Valid values: `1.0.0`, `2.0.0`.
     */
    public val policyVersion: Output<String>
        get() = javaResource.policyVersion().applyValue({ args0 -> args0 })

    /**
     * The status of the Backup Policy instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Specify the Protection of Server UUID List.
     */
    public val uuidLists: Output<List<String>>
        get() = javaResource.uuidLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.threatdetection.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
