@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Backup Policy resource.
 * For information about Threat Detection Backup Policy and how to use it, see [What is Backup Policy](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.threatdetection.getAssets({
 *     machineTypes: "ecs",
 * });
 * const defaultBackupPolicy = new alicloud.threatdetection.BackupPolicy("default", {
 *     backupPolicyName: "tf-example-name",
 *     policy: "{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *     policyVersion: "2.0.0",
 *     uuidLists: [_default&#46;then(_default => _default&#46;ids?&#46;[0])],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.get_assets(machine_types="ecs")
 * default_backup_policy = alicloud.threatdetection.BackupPolicy("default",
 *     backup_policy_name="tf-example-name",
 *     policy="{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *     policy_version="2.0.0",
 *     uuid_lists=[default&#46;ids[0]])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ThreatDetection.GetAssets.Invoke(new()
 *     {
 *         MachineTypes = "ecs",
 *     });
 *     var defaultBackupPolicy = new AliCloud.ThreatDetection.BackupPolicy("default", new()
 *     {
 *         BackupPolicyName = "tf-example-name",
 *         Policy = "{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}",
 *         PolicyVersion = "2.0.0",
 *         UuidLists = new[]
 *         {
 *             @default.Apply(@default => @default.Apply(getAssetsResult => getAssetsResult.Ids[0])),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := threatdetection.GetAssets(ctx, &threatdetection.GetAssetsArgs{
 * 			MachineTypes: pulumi.StringRef("ecs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewBackupPolicy(ctx, "default", &threatdetection.BackupPolicyArgs{
 * 			BackupPolicyName: pulumi.String("tf-example-name"),
 * 			Policy:           pulumi.String("{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}"),
 * 			PolicyVersion:    pulumi.String("2.0.0"),
 * 			UuidLists: pulumi.StringArray{
 * 				pulumi.String(_default.Ids[0]),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetAssetsArgs;
 * import com.pulumi.alicloud.threatdetection.BackupPolicy;
 * import com.pulumi.alicloud.threatdetection.BackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ThreatdetectionFunctions.getAssets(GetAssetsArgs.builder()
 *             .machineTypes("ecs")
 *             .build());
 *         var defaultBackupPolicy = new BackupPolicy("defaultBackupPolicy", BackupPolicyArgs.builder()
 *             .backupPolicyName("tf-example-name")
 *             .policy("{\"Exclude\":[\"/bin/\",\"/usr/bin/\",\"/sbin/\",\"/boot/\",\"/proc/\",\"/sys/\",\"/srv/\",\"/lib/\",\"/selinux/\",\"/usr/sbin/\",\"/run/\",\"/lib32/\",\"/lib64/\",\"/lost+found/\",\"/var/lib/kubelet/\",\"/var/lib/ntp/proc\",\"/var/lib/container\"],\"ExcludeSystemPath\":true,\"Include\":[],\"IsDefault\":1,\"Retention\":7,\"Schedule\":\"I|1668703620|PT24H\",\"Source\":[],\"SpeedLimiter\":\"\",\"UseVss\":true}")
 *             .policyVersion("2.0.0")
 *             .uuidLists(default_.ids()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultBackupPolicy:
 *     type: alicloud:threatdetection:BackupPolicy
 *     name: default
 *     properties:
 *       backupPolicyName: tf-example-name
 *       policy: '{"Exclude":["/bin/","/usr/bin/","/sbin/","/boot/","/proc/","/sys/","/srv/","/lib/","/selinux/","/usr/sbin/","/run/","/lib32/","/lib64/","/lost+found/","/var/lib/kubelet/","/var/lib/ntp/proc","/var/lib/container"],"ExcludeSystemPath":true,"Include":[],"IsDefault":1,"Retention":7,"Schedule":"I|1668703620|PT24H","Source":[],"SpeedLimiter":"","UseVss":true}'
 *       policyVersion: 2.0.0
 *       uuidLists:
 *         - ${default.ids[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getAssets
 *       Arguments:
 *         machineTypes: ecs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Backup Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/backupPolicy:BackupPolicy example <id>
 * ```
 * @property backupPolicyName Protection of the Name of the Policy.
 * @property policy The Specified Protection Policies of the Specific Configuration. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
 * @property policyRegionId The region ID of the non-Alibaba cloud server. You can call the [DescribeSupportRegion](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describesupportregion) interface to view the region supported by anti-ransomware, and then select the region supported by anti-ransomware according to the region where your non-Alibaba cloud server is located.
 * @property policyVersion Anti-Blackmail Policy Version. Valid values: `1.0.0`, `2.0.0`.
 * @property uuidLists Specify the Protection of Server UUID List.
 */
public data class BackupPolicyArgs(
    public val backupPolicyName: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val policyRegionId: Output<String>? = null,
    public val policyVersion: Output<String>? = null,
    public val uuidLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.BackupPolicyArgs =
        com.pulumi.alicloud.threatdetection.BackupPolicyArgs.builder()
            .backupPolicyName(backupPolicyName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .policyRegionId(policyRegionId?.applyValue({ args0 -> args0 }))
            .policyVersion(policyVersion?.applyValue({ args0 -> args0 }))
            .uuidLists(uuidLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupPolicyName: Output<String>? = null

    private var policy: Output<String>? = null

    private var policyRegionId: Output<String>? = null

    private var policyVersion: Output<String>? = null

    private var uuidLists: Output<List<String>>? = null

    /**
     * @param value Protection of the Name of the Policy.
     */
    @JvmName("udpyoaphgpdmdieu")
    public suspend fun backupPolicyName(`value`: Output<String>) {
        this.backupPolicyName = value
    }

    /**
     * @param value The Specified Protection Policies of the Specific Configuration. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
     */
    @JvmName("sliaydlgbnutknsw")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The region ID of the non-Alibaba cloud server. You can call the [DescribeSupportRegion](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describesupportregion) interface to view the region supported by anti-ransomware, and then select the region supported by anti-ransomware according to the region where your non-Alibaba cloud server is located.
     */
    @JvmName("tdaakhrrjkgsksqr")
    public suspend fun policyRegionId(`value`: Output<String>) {
        this.policyRegionId = value
    }

    /**
     * @param value Anti-Blackmail Policy Version. Valid values: `1.0.0`, `2.0.0`.
     */
    @JvmName("dsretrqwdhqdrjdq")
    public suspend fun policyVersion(`value`: Output<String>) {
        this.policyVersion = value
    }

    /**
     * @param value Specify the Protection of Server UUID List.
     */
    @JvmName("rwhdxqvqttibdtjm")
    public suspend fun uuidLists(`value`: Output<List<String>>) {
        this.uuidLists = value
    }

    @JvmName("kroornfnnuwsslot")
    public suspend fun uuidLists(vararg values: Output<String>) {
        this.uuidLists = Output.all(values.asList())
    }

    /**
     * @param values Specify the Protection of Server UUID List.
     */
    @JvmName("degvypxfggkfasyc")
    public suspend fun uuidLists(values: List<Output<String>>) {
        this.uuidLists = Output.all(values)
    }

    /**
     * @param value Protection of the Name of the Policy.
     */
    @JvmName("gvnciycskhxomaee")
    public suspend fun backupPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPolicyName = mapped
    }

    /**
     * @param value The Specified Protection Policies of the Specific Configuration. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createbackuppolicy).
     */
    @JvmName("wusjdpxfrrbbsclo")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The region ID of the non-Alibaba cloud server. You can call the [DescribeSupportRegion](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describesupportregion) interface to view the region supported by anti-ransomware, and then select the region supported by anti-ransomware according to the region where your non-Alibaba cloud server is located.
     */
    @JvmName("rhomnndgyixacing")
    public suspend fun policyRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRegionId = mapped
    }

    /**
     * @param value Anti-Blackmail Policy Version. Valid values: `1.0.0`, `2.0.0`.
     */
    @JvmName("ivfrkgjhfnuwdrfa")
    public suspend fun policyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyVersion = mapped
    }

    /**
     * @param value Specify the Protection of Server UUID List.
     */
    @JvmName("dxsbhnweabamxsnt")
    public suspend fun uuidLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuidLists = mapped
    }

    /**
     * @param values Specify the Protection of Server UUID List.
     */
    @JvmName("kpvxuaakfaehtfse")
    public suspend fun uuidLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uuidLists = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupPolicyName = backupPolicyName,
        policy = policy,
        policyRegionId = policyRegionId,
        policyVersion = policyVersion,
        uuidLists = uuidLists,
    )
}
