@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BaselineStrategy].
 */
@PulumiTagMarker
public class BaselineStrategyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BaselineStrategyArgs = BaselineStrategyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BaselineStrategyArgsBuilder.() -> Unit) {
        val builder = BaselineStrategyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BaselineStrategy {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.BaselineStrategy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BaselineStrategy(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Baseline Strategy resource.
 * For information about Threat Detection Baseline Strategy and how to use it, see [What is Baseline Strategy](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-modifystrategy).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.BaselineStrategy("default", {
 *     customType: "custom",
 *     endTime: "08:00:00",
 *     baselineStrategyName: "apispec",
 *     cycleDays: 3,
 *     targetType: "groupId",
 *     startTime: "05:00:00",
 *     riskSubTypeName: "hc_exploit_redis",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.BaselineStrategy("default",
 *     custom_type="custom",
 *     end_time="08:00:00",
 *     baseline_strategy_name="apispec",
 *     cycle_days=3,
 *     target_type="groupId",
 *     start_time="05:00:00",
 *     risk_sub_type_name="hc_exploit_redis")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.BaselineStrategy("default", new()
 *     {
 *         CustomType = "custom",
 *         EndTime = "08:00:00",
 *         BaselineStrategyName = "apispec",
 *         CycleDays = 3,
 *         TargetType = "groupId",
 *         StartTime = "05:00:00",
 *         RiskSubTypeName = "hc_exploit_redis",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewBaselineStrategy(ctx, "default", &threatdetection.BaselineStrategyArgs{
 * 			CustomType:           pulumi.String("custom"),
 * 			EndTime:              pulumi.String("08:00:00"),
 * 			BaselineStrategyName: pulumi.String("apispec"),
 * 			CycleDays:            pulumi.Int(3),
 * 			TargetType:           pulumi.String("groupId"),
 * 			StartTime:            pulumi.String("05:00:00"),
 * 			RiskSubTypeName:      pulumi.String("hc_exploit_redis"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.BaselineStrategy;
 * import com.pulumi.alicloud.threatdetection.BaselineStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BaselineStrategy("default", BaselineStrategyArgs.builder()
 *             .customType("custom")
 *             .endTime("08:00:00")
 *             .baselineStrategyName("apispec")
 *             .cycleDays(3)
 *             .targetType("groupId")
 *             .startTime("05:00:00")
 *             .riskSubTypeName("hc_exploit_redis")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:BaselineStrategy
 *     properties:
 *       customType: custom
 *       endTime: 08:00:00
 *       baselineStrategyName: apispec
 *       cycleDays: 3
 *       targetType: groupId
 *       startTime: 05:00:00
 *       riskSubTypeName: hc_exploit_redis
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Baseline Strategy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/baselineStrategy:BaselineStrategy example <id>
 * ```
 */
public class BaselineStrategy internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.BaselineStrategy,
) : KotlinCustomResource(javaResource, BaselineStrategyMapper) {
    /**
     * The ID of the baseline check policy.
     */
    public val baselineStrategyId: Output<String>
        get() = javaResource.baselineStrategyId().applyValue({ args0 -> args0 })

    /**
     * Policy name.
     */
    public val baselineStrategyName: Output<String>
        get() = javaResource.baselineStrategyName().applyValue({ args0 -> args0 })

    /**
     * The type of policy. Value:
     * * **common**: standard policy
     * * **custom**: custom policy
     */
    public val customType: Output<String>
        get() = javaResource.customType().applyValue({ args0 -> args0 })

    /**
     * The detection period of the policy.
     */
    public val cycleDays: Output<Int>
        get() = javaResource.cycleDays().applyValue({ args0 -> args0 })

    /**
     * The detection period of the policy. Value:
     * * **0**: 0:00~06:00
     * * **6**: 6:00~12:00
     * * **12**: 12:00~18:00
     * * **18**: 18:00~24:00
     */
    public val cycleStartTime: Output<Int>
        get() = javaResource.cycleStartTime().applyValue({ args0 -> args0 })

    /**
     * The baseline check policy execution end time.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * Detection item subtype.
     */
    public val riskSubTypeName: Output<String>
        get() = javaResource.riskSubTypeName().applyValue({ args0 -> args0 })

    /**
     * The baseline check policy start time.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The method of adding assets that take effect from the policy. Value:
     * * **groupId**: Added by asset group.
     * * **uuid**: Add by single asset.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })
}

public object BaselineStrategyMapper : ResourceMapper<BaselineStrategy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.BaselineStrategy::class == javaResource::class

    override fun map(javaResource: Resource): BaselineStrategy = BaselineStrategy(
        javaResource as
            com.pulumi.alicloud.threatdetection.BaselineStrategy,
    )
}

/**
 * @see [BaselineStrategy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BaselineStrategy].
 */
public suspend fun baselineStrategy(
    name: String,
    block: suspend BaselineStrategyResourceBuilder.() -> Unit,
): BaselineStrategy {
    val builder = BaselineStrategyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BaselineStrategy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun baselineStrategy(name: String): BaselineStrategy {
    val builder = BaselineStrategyResourceBuilder()
    builder.name(name)
    return builder.build()
}
