@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.BaselineStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Baseline Strategy resource.
 * For information about Threat Detection Baseline Strategy and how to use it, see [What is Baseline Strategy](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-modifystrategy).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.BaselineStrategy("default", {
 *     customType: "custom",
 *     endTime: "08:00:00",
 *     baselineStrategyName: "apispec",
 *     cycleDays: 3,
 *     targetType: "groupId",
 *     startTime: "05:00:00",
 *     riskSubTypeName: "hc_exploit_redis",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.BaselineStrategy("default",
 *     custom_type="custom",
 *     end_time="08:00:00",
 *     baseline_strategy_name="apispec",
 *     cycle_days=3,
 *     target_type="groupId",
 *     start_time="05:00:00",
 *     risk_sub_type_name="hc_exploit_redis")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.BaselineStrategy("default", new()
 *     {
 *         CustomType = "custom",
 *         EndTime = "08:00:00",
 *         BaselineStrategyName = "apispec",
 *         CycleDays = 3,
 *         TargetType = "groupId",
 *         StartTime = "05:00:00",
 *         RiskSubTypeName = "hc_exploit_redis",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewBaselineStrategy(ctx, "default", &threatdetection.BaselineStrategyArgs{
 * 			CustomType:           pulumi.String("custom"),
 * 			EndTime:              pulumi.String("08:00:00"),
 * 			BaselineStrategyName: pulumi.String("apispec"),
 * 			CycleDays:            pulumi.Int(3),
 * 			TargetType:           pulumi.String("groupId"),
 * 			StartTime:            pulumi.String("05:00:00"),
 * 			RiskSubTypeName:      pulumi.String("hc_exploit_redis"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.BaselineStrategy;
 * import com.pulumi.alicloud.threatdetection.BaselineStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BaselineStrategy("default", BaselineStrategyArgs.builder()
 *             .customType("custom")
 *             .endTime("08:00:00")
 *             .baselineStrategyName("apispec")
 *             .cycleDays(3)
 *             .targetType("groupId")
 *             .startTime("05:00:00")
 *             .riskSubTypeName("hc_exploit_redis")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:BaselineStrategy
 *     properties:
 *       customType: custom
 *       endTime: 08:00:00
 *       baselineStrategyName: apispec
 *       cycleDays: 3
 *       targetType: groupId
 *       startTime: 05:00:00
 *       riskSubTypeName: hc_exploit_redis
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Baseline Strategy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/baselineStrategy:BaselineStrategy example <id>
 * ```
 * @property baselineStrategyName Policy name.
 * @property customType The type of policy. Value:
 * * **common**: standard policy
 * * **custom**: custom policy
 * @property cycleDays The detection period of the policy.
 * @property cycleStartTime The detection period of the policy. Value:
 * * **0**: 0:00~06:00
 * * **6**: 6:00~12:00
 * * **12**: 12:00~18:00
 * * **18**: 18:00~24:00
 * @property endTime The baseline check policy execution end time.
 * @property riskSubTypeName Detection item subtype.
 * @property startTime The baseline check policy start time.
 * @property targetType The method of adding assets that take effect from the policy. Value:
 * * **groupId**: Added by asset group.
 * * **uuid**: Add by single asset.
 */
public data class BaselineStrategyArgs(
    public val baselineStrategyName: Output<String>? = null,
    public val customType: Output<String>? = null,
    public val cycleDays: Output<Int>? = null,
    public val cycleStartTime: Output<Int>? = null,
    public val endTime: Output<String>? = null,
    public val riskSubTypeName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.BaselineStrategyArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.BaselineStrategyArgs =
        com.pulumi.alicloud.threatdetection.BaselineStrategyArgs.builder()
            .baselineStrategyName(baselineStrategyName?.applyValue({ args0 -> args0 }))
            .customType(customType?.applyValue({ args0 -> args0 }))
            .cycleDays(cycleDays?.applyValue({ args0 -> args0 }))
            .cycleStartTime(cycleStartTime?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .riskSubTypeName(riskSubTypeName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BaselineStrategyArgs].
 */
@PulumiTagMarker
public class BaselineStrategyArgsBuilder internal constructor() {
    private var baselineStrategyName: Output<String>? = null

    private var customType: Output<String>? = null

    private var cycleDays: Output<Int>? = null

    private var cycleStartTime: Output<Int>? = null

    private var endTime: Output<String>? = null

    private var riskSubTypeName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value Policy name.
     */
    @JvmName("hqfsciwdpwyvlhtr")
    public suspend fun baselineStrategyName(`value`: Output<String>) {
        this.baselineStrategyName = value
    }

    /**
     * @param value The type of policy. Value:
     * * **common**: standard policy
     * * **custom**: custom policy
     */
    @JvmName("mcusijgxvapcvaxf")
    public suspend fun customType(`value`: Output<String>) {
        this.customType = value
    }

    /**
     * @param value The detection period of the policy.
     */
    @JvmName("fxnnaqcwhqfjxrpf")
    public suspend fun cycleDays(`value`: Output<Int>) {
        this.cycleDays = value
    }

    /**
     * @param value The detection period of the policy. Value:
     * * **0**: 0:00~06:00
     * * **6**: 6:00~12:00
     * * **12**: 12:00~18:00
     * * **18**: 18:00~24:00
     */
    @JvmName("odbxdeosmfkiulkc")
    public suspend fun cycleStartTime(`value`: Output<Int>) {
        this.cycleStartTime = value
    }

    /**
     * @param value The baseline check policy execution end time.
     */
    @JvmName("ekgscuwmbvtdedfn")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value Detection item subtype.
     */
    @JvmName("pbwuoydyawvuphvd")
    public suspend fun riskSubTypeName(`value`: Output<String>) {
        this.riskSubTypeName = value
    }

    /**
     * @param value The baseline check policy start time.
     */
    @JvmName("nrganuaaqniummws")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The method of adding assets that take effect from the policy. Value:
     * * **groupId**: Added by asset group.
     * * **uuid**: Add by single asset.
     */
    @JvmName("fydddwvhfpyqttnw")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Policy name.
     */
    @JvmName("bwgaymlrafbycbwg")
    public suspend fun baselineStrategyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineStrategyName = mapped
    }

    /**
     * @param value The type of policy. Value:
     * * **common**: standard policy
     * * **custom**: custom policy
     */
    @JvmName("tubnbnhpxvscbmpu")
    public suspend fun customType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customType = mapped
    }

    /**
     * @param value The detection period of the policy.
     */
    @JvmName("osheppldfgnjnjgt")
    public suspend fun cycleDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cycleDays = mapped
    }

    /**
     * @param value The detection period of the policy. Value:
     * * **0**: 0:00~06:00
     * * **6**: 6:00~12:00
     * * **12**: 12:00~18:00
     * * **18**: 18:00~24:00
     */
    @JvmName("qqxgbxctdkoglfmy")
    public suspend fun cycleStartTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cycleStartTime = mapped
    }

    /**
     * @param value The baseline check policy execution end time.
     */
    @JvmName("vwnwfggiuempjbfy")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value Detection item subtype.
     */
    @JvmName("qkdvqoaripfrcwyi")
    public suspend fun riskSubTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.riskSubTypeName = mapped
    }

    /**
     * @param value The baseline check policy start time.
     */
    @JvmName("toyfvyangdpdiios")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The method of adding assets that take effect from the policy. Value:
     * * **groupId**: Added by asset group.
     * * **uuid**: Add by single asset.
     */
    @JvmName("wgbcfeqkyefoiwua")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): BaselineStrategyArgs = BaselineStrategyArgs(
        baselineStrategyName = baselineStrategyName,
        customType = customType,
        cycleDays = cycleDays,
        cycleStartTime = cycleStartTime,
        endTime = endTime,
        riskSubTypeName = riskSubTypeName,
        startTime = startTime,
        targetType = targetType,
    )
}
