@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ClientFileProtect].
 */
@PulumiTagMarker
public class ClientFileProtectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientFileProtectArgs = ClientFileProtectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientFileProtectArgsBuilder.() -> Unit) {
        val builder = ClientFileProtectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientFileProtect {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.ClientFileProtect(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClientFileProtect(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Client File Protect resource. Client core file protection event monitoring, including file reading and writing, deletion, and permission change.
 * For information about Threat Detection Client File Protect and how to use it, see [What is Client File Protect](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createfileprotectrule).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ClientFileProtect("default", {
 *     status: 0,
 *     filePaths: ["/usr/local"],
 *     fileOps: ["CREATE"],
 *     ruleAction: "pass",
 *     procPaths: ["/usr/local"],
 *     alertLevel: 0,
 *     switchId: "FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *     ruleName: "rule_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ClientFileProtect("default",
 *     status=0,
 *     file_paths=["/usr/local"],
 *     file_ops=["CREATE"],
 *     rule_action="pass",
 *     proc_paths=["/usr/local"],
 *     alert_level=0,
 *     switch_id="FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *     rule_name="rule_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ClientFileProtect("default", new()
 *     {
 *         Status = 0,
 *         FilePaths = new[]
 *         {
 *             "/usr/local",
 *         },
 *         FileOps = new[]
 *         {
 *             "CREATE",
 *         },
 *         RuleAction = "pass",
 *         ProcPaths = new[]
 *         {
 *             "/usr/local",
 *         },
 *         AlertLevel = 0,
 *         SwitchId = "FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *         RuleName = "rule_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewClientFileProtect(ctx, "default", &threatdetection.ClientFileProtectArgs{
 * 			Status: pulumi.Int(0),
 * 			FilePaths: pulumi.StringArray{
 * 				pulumi.String("/usr/local"),
 * 			},
 * 			FileOps: pulumi.StringArray{
 * 				pulumi.String("CREATE"),
 * 			},
 * 			RuleAction: pulumi.String("pass"),
 * 			ProcPaths: pulumi.StringArray{
 * 				pulumi.String("/usr/local"),
 * 			},
 * 			AlertLevel: pulumi.Int(0),
 * 			SwitchId:   pulumi.String("FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929"),
 * 			RuleName:   pulumi.String("rule_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ClientFileProtect;
 * import com.pulumi.alicloud.threatdetection.ClientFileProtectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ClientFileProtect("default", ClientFileProtectArgs.builder()
 *             .status("0")
 *             .filePaths("/usr/local")
 *             .fileOps("CREATE")
 *             .ruleAction("pass")
 *             .procPaths("/usr/local")
 *             .alertLevel("0")
 *             .switchId("FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929")
 *             .ruleName("rule_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ClientFileProtect
 *     properties:
 *       status: '0'
 *       filePaths:
 *         - /usr/local
 *       fileOps:
 *         - CREATE
 *       ruleAction: pass
 *       procPaths:
 *         - /usr/local
 *       alertLevel: '0'
 *       switchId: FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929
 *       ruleName: rule_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Client File Protect can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/clientFileProtect:ClientFileProtect example <id>
 * ```
 */
public class ClientFileProtect internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.ClientFileProtect,
) : KotlinCustomResource(javaResource, ClientFileProtectMapper) {
    /**
     * 0 no alert 1 info 2 suspicious 3 critical.
     */
    public val alertLevel: Output<Int>?
        get() = javaResource.alertLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * file operation.
     */
    public val fileOps: Output<List<String>>
        get() = javaResource.fileOps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * file path.
     */
    public val filePaths: Output<List<String>>
        get() = javaResource.filePaths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * process path.
     */
    public val procPaths: Output<List<String>>
        get() = javaResource.procPaths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * rule action, pass or alert.
     */
    public val ruleAction: Output<String>
        get() = javaResource.ruleAction().applyValue({ args0 -> args0 })

    /**
     * ruleName.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })

    /**
     * rule status 0 is disable 1 is enable.
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * switch id.
     */
    public val switchId: Output<String>?
        get() = javaResource.switchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ClientFileProtectMapper : ResourceMapper<ClientFileProtect> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.ClientFileProtect::class == javaResource::class

    override fun map(javaResource: Resource): ClientFileProtect = ClientFileProtect(
        javaResource as
            com.pulumi.alicloud.threatdetection.ClientFileProtect,
    )
}

/**
 * @see [ClientFileProtect].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientFileProtect].
 */
public suspend fun clientFileProtect(
    name: String,
    block: suspend ClientFileProtectResourceBuilder.() -> Unit,
): ClientFileProtect {
    val builder = ClientFileProtectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientFileProtect].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientFileProtect(name: String): ClientFileProtect {
    val builder = ClientFileProtectResourceBuilder()
    builder.name(name)
    return builder.build()
}
