@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.ClientFileProtectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Client File Protect resource. Client core file protection event monitoring, including file reading and writing, deletion, and permission change.
 * For information about Threat Detection Client File Protect and how to use it, see [What is Client File Protect](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createfileprotectrule).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ClientFileProtect("default", {
 *     status: 0,
 *     filePaths: ["/usr/local"],
 *     fileOps: ["CREATE"],
 *     ruleAction: "pass",
 *     procPaths: ["/usr/local"],
 *     alertLevel: 0,
 *     switchId: "FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *     ruleName: "rule_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ClientFileProtect("default",
 *     status=0,
 *     file_paths=["/usr/local"],
 *     file_ops=["CREATE"],
 *     rule_action="pass",
 *     proc_paths=["/usr/local"],
 *     alert_level=0,
 *     switch_id="FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *     rule_name="rule_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ClientFileProtect("default", new()
 *     {
 *         Status = 0,
 *         FilePaths = new[]
 *         {
 *             "/usr/local",
 *         },
 *         FileOps = new[]
 *         {
 *             "CREATE",
 *         },
 *         RuleAction = "pass",
 *         ProcPaths = new[]
 *         {
 *             "/usr/local",
 *         },
 *         AlertLevel = 0,
 *         SwitchId = "FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929",
 *         RuleName = "rule_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewClientFileProtect(ctx, "default", &threatdetection.ClientFileProtectArgs{
 * 			Status: pulumi.Int(0),
 * 			FilePaths: pulumi.StringArray{
 * 				pulumi.String("/usr/local"),
 * 			},
 * 			FileOps: pulumi.StringArray{
 * 				pulumi.String("CREATE"),
 * 			},
 * 			RuleAction: pulumi.String("pass"),
 * 			ProcPaths: pulumi.StringArray{
 * 				pulumi.String("/usr/local"),
 * 			},
 * 			AlertLevel: pulumi.Int(0),
 * 			SwitchId:   pulumi.String("FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929"),
 * 			RuleName:   pulumi.String("rule_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ClientFileProtect;
 * import com.pulumi.alicloud.threatdetection.ClientFileProtectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ClientFileProtect("default", ClientFileProtectArgs.builder()
 *             .status("0")
 *             .filePaths("/usr/local")
 *             .fileOps("CREATE")
 *             .ruleAction("pass")
 *             .procPaths("/usr/local")
 *             .alertLevel("0")
 *             .switchId("FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929")
 *             .ruleName("rule_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ClientFileProtect
 *     properties:
 *       status: '0'
 *       filePaths:
 *         - /usr/local
 *       fileOps:
 *         - CREATE
 *       ruleAction: pass
 *       procPaths:
 *         - /usr/local
 *       alertLevel: '0'
 *       switchId: FILE_PROTECT_RULE_SWITCH_TYPE_1693474122929
 *       ruleName: rule_example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Client File Protect can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/clientFileProtect:ClientFileProtect example <id>
 * ```
 * @property alertLevel 0 no alert 1 info 2 suspicious 3 critical.
 * @property fileOps file operation.
 * @property filePaths file path.
 * @property procPaths process path.
 * @property ruleAction rule action, pass or alert.
 * @property ruleName ruleName.
 * @property status rule status 0 is disable 1 is enable.
 * @property switchId switch id.
 */
public data class ClientFileProtectArgs(
    public val alertLevel: Output<Int>? = null,
    public val fileOps: Output<List<String>>? = null,
    public val filePaths: Output<List<String>>? = null,
    public val procPaths: Output<List<String>>? = null,
    public val ruleAction: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val status: Output<Int>? = null,
    public val switchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.ClientFileProtectArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.ClientFileProtectArgs =
        com.pulumi.alicloud.threatdetection.ClientFileProtectArgs.builder()
            .alertLevel(alertLevel?.applyValue({ args0 -> args0 }))
            .fileOps(fileOps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .filePaths(filePaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .procPaths(procPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleAction(ruleAction?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .switchId(switchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientFileProtectArgs].
 */
@PulumiTagMarker
public class ClientFileProtectArgsBuilder internal constructor() {
    private var alertLevel: Output<Int>? = null

    private var fileOps: Output<List<String>>? = null

    private var filePaths: Output<List<String>>? = null

    private var procPaths: Output<List<String>>? = null

    private var ruleAction: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var status: Output<Int>? = null

    private var switchId: Output<String>? = null

    /**
     * @param value 0 no alert 1 info 2 suspicious 3 critical.
     */
    @JvmName("ovmufwpssccxnhkh")
    public suspend fun alertLevel(`value`: Output<Int>) {
        this.alertLevel = value
    }

    /**
     * @param value file operation.
     */
    @JvmName("imuielpqxjqgjtcv")
    public suspend fun fileOps(`value`: Output<List<String>>) {
        this.fileOps = value
    }

    @JvmName("vnokipdxkovqacls")
    public suspend fun fileOps(vararg values: Output<String>) {
        this.fileOps = Output.all(values.asList())
    }

    /**
     * @param values file operation.
     */
    @JvmName("vemdgdviguuwlgmc")
    public suspend fun fileOps(values: List<Output<String>>) {
        this.fileOps = Output.all(values)
    }

    /**
     * @param value file path.
     */
    @JvmName("iidgavyonlrpbaen")
    public suspend fun filePaths(`value`: Output<List<String>>) {
        this.filePaths = value
    }

    @JvmName("vxqxxaoqwhndkjky")
    public suspend fun filePaths(vararg values: Output<String>) {
        this.filePaths = Output.all(values.asList())
    }

    /**
     * @param values file path.
     */
    @JvmName("bmxudopnmdxmrhdi")
    public suspend fun filePaths(values: List<Output<String>>) {
        this.filePaths = Output.all(values)
    }

    /**
     * @param value process path.
     */
    @JvmName("wanpqgfithkupqtv")
    public suspend fun procPaths(`value`: Output<List<String>>) {
        this.procPaths = value
    }

    @JvmName("qirynjiqfucelbde")
    public suspend fun procPaths(vararg values: Output<String>) {
        this.procPaths = Output.all(values.asList())
    }

    /**
     * @param values process path.
     */
    @JvmName("kblatqcdplxcrlae")
    public suspend fun procPaths(values: List<Output<String>>) {
        this.procPaths = Output.all(values)
    }

    /**
     * @param value rule action, pass or alert.
     */
    @JvmName("mgnfqqujorkhjnqq")
    public suspend fun ruleAction(`value`: Output<String>) {
        this.ruleAction = value
    }

    /**
     * @param value ruleName.
     */
    @JvmName("wrurxvhjkhsonrsq")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value rule status 0 is disable 1 is enable.
     */
    @JvmName("sklypdwjqqjkuejt")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value switch id.
     */
    @JvmName("roweuphgpwyacuke")
    public suspend fun switchId(`value`: Output<String>) {
        this.switchId = value
    }

    /**
     * @param value 0 no alert 1 info 2 suspicious 3 critical.
     */
    @JvmName("wxkyugwshehudyoc")
    public suspend fun alertLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertLevel = mapped
    }

    /**
     * @param value file operation.
     */
    @JvmName("nsdphhdglefkdrcm")
    public suspend fun fileOps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileOps = mapped
    }

    /**
     * @param values file operation.
     */
    @JvmName("lmquhwiaxokfgysd")
    public suspend fun fileOps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileOps = mapped
    }

    /**
     * @param value file path.
     */
    @JvmName("nvnnurbxkipjopfv")
    public suspend fun filePaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param values file path.
     */
    @JvmName("itgdixxlmkcaevqm")
    public suspend fun filePaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filePaths = mapped
    }

    /**
     * @param value process path.
     */
    @JvmName("llivjlppgtncavbb")
    public suspend fun procPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.procPaths = mapped
    }

    /**
     * @param values process path.
     */
    @JvmName("uvypdparbcycuyik")
    public suspend fun procPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.procPaths = mapped
    }

    /**
     * @param value rule action, pass or alert.
     */
    @JvmName("isnutlclxjcjxvtp")
    public suspend fun ruleAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleAction = mapped
    }

    /**
     * @param value ruleName.
     */
    @JvmName("ckbvocxgswbxdjpp")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value rule status 0 is disable 1 is enable.
     */
    @JvmName("iviapjqjwhmirolg")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value switch id.
     */
    @JvmName("uomqkuleamytgncr")
    public suspend fun switchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.switchId = mapped
    }

    internal fun build(): ClientFileProtectArgs = ClientFileProtectArgs(
        alertLevel = alertLevel,
        fileOps = fileOps,
        filePaths = filePaths,
        procPaths = procPaths,
        ruleAction = ruleAction,
        ruleName = ruleName,
        status = status,
        switchId = switchId,
    )
}
