@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClientUserDefineRule].
 */
@PulumiTagMarker
public class ClientUserDefineRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientUserDefineRuleArgs = ClientUserDefineRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientUserDefineRuleArgsBuilder.() -> Unit) {
        val builder = ClientUserDefineRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientUserDefineRule {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.ClientUserDefineRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClientUserDefineRule(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Client User Define Rule resource. Malicious Behavior Defense Custom Rules.
 * For information about Threat Detection Client User Define Rule and how to use it, see [What is Client User Define Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-addclientuserdefinerule).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ClientUserDefineRule("default", {
 *     actionType: 0,
 *     platform: "windows",
 *     registryContent: "123",
 *     clientUserDefineRuleName: name,
 *     parentProcPath: "/root/bash",
 *     type: 5,
 *     cmdline: "bash",
 *     procPath: "/root/bash",
 *     parentCmdline: "bash",
 *     registryKey: "123",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ClientUserDefineRule("default",
 *     action_type=0,
 *     platform="windows",
 *     registry_content="123",
 *     client_user_define_rule_name=name,
 *     parent_proc_path="/root/bash",
 *     type=5,
 *     cmdline="bash",
 *     proc_path="/root/bash",
 *     parent_cmdline="bash",
 *     registry_key="123")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ClientUserDefineRule("default", new()
 *     {
 *         ActionType = 0,
 *         Platform = "windows",
 *         RegistryContent = "123",
 *         ClientUserDefineRuleName = name,
 *         ParentProcPath = "/root/bash",
 *         Type = 5,
 *         Cmdline = "bash",
 *         ProcPath = "/root/bash",
 *         ParentCmdline = "bash",
 *         RegistryKey = "123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewClientUserDefineRule(ctx, "default", &threatdetection.ClientUserDefineRuleArgs{
 * 			ActionType:               pulumi.Int(0),
 * 			Platform:                 pulumi.String("windows"),
 * 			RegistryContent:          pulumi.String("123"),
 * 			ClientUserDefineRuleName: pulumi.String(name),
 * 			ParentProcPath:           pulumi.String("/root/bash"),
 * 			Type:                     pulumi.Int(5),
 * 			Cmdline:                  pulumi.String("bash"),
 * 			ProcPath:                 pulumi.String("/root/bash"),
 * 			ParentCmdline:            pulumi.String("bash"),
 * 			RegistryKey:              pulumi.String("123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ClientUserDefineRule;
 * import com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ClientUserDefineRule("default", ClientUserDefineRuleArgs.builder()
 *             .actionType("0")
 *             .platform("windows")
 *             .registryContent("123")
 *             .clientUserDefineRuleName(name)
 *             .parentProcPath("/root/bash")
 *             .type("5")
 *             .cmdline("bash")
 *             .procPath("/root/bash")
 *             .parentCmdline("bash")
 *             .registryKey("123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ClientUserDefineRule
 *     properties:
 *       actionType: '0'
 *       platform: windows
 *       registryContent: '123'
 *       clientUserDefineRuleName: ${name}
 *       parentProcPath: /root/bash
 *       type: '5'
 *       cmdline: bash
 *       procPath: /root/bash
 *       parentCmdline: bash
 *       registryKey: '123'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Client User Define Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/clientUserDefineRule:ClientUserDefineRule example <id>
 * ```
 */
public class ClientUserDefineRule internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.ClientUserDefineRule,
) : KotlinCustomResource(javaResource, ClientUserDefineRuleMapper) {
    /**
     * The operation type. Value:
     * - **0**: plus White
     * - **1**: Plus Black.
     */
    public val actionType: Output<Int>
        get() = javaResource.actionType().applyValue({ args0 -> args0 })

    /**
     * The custom rule name.
     */
    public val clientUserDefineRuleName: Output<String>
        get() = javaResource.clientUserDefineRuleName().applyValue({ args0 -> args0 })

    /**
     * Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
     */
    public val cmdline: Output<String>?
        get() = javaResource.cmdline().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
     */
    public val filePath: Output<String>?
        get() = javaResource.filePath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
     */
    public val hash: Output<String>?
        get() = javaResource.hash().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IP address. When the value of the Type attribute is 3, the Ip attribute is required.
     */
    public val ip: Output<String>?
        get() = javaResource.ip().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
     */
    public val newFilePath: Output<String>?
        get() = javaResource.newFilePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The parent command line.
     */
    public val parentCmdline: Output<String>?
        get() = javaResource.parentCmdline().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Parent process path.
     */
    public val parentProcPath: Output<String>?
        get() = javaResource.parentProcPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The operating system type. Value:
     * - **windows**:widows
     * - **linux**:linux
     * - **all**: all.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
     */
    public val portStr: Output<String>
        get() = javaResource.portStr().applyValue({ args0 -> args0 })

    /**
     * The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
     */
    public val procPath: Output<String>?
        get() = javaResource.procPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    public val registryContent: Output<String>?
        get() = javaResource.registryContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    public val registryKey: Output<String>?
        get() = javaResource.registryKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The rule type. Value:
     * - **1**: Process hash
     * - **2**: command line
     * - **3**: Process network
     * - **4**: File reading and writing
     * - **5**: Operate the registry
     * - **6**: Load Dynamic Link Library
     * - **7**: File Rename.
     */
    public val type: Output<Int>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClientUserDefineRuleMapper : ResourceMapper<ClientUserDefineRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.ClientUserDefineRule::class == javaResource::class

    override fun map(javaResource: Resource): ClientUserDefineRule = ClientUserDefineRule(
        javaResource
            as com.pulumi.alicloud.threatdetection.ClientUserDefineRule,
    )
}

/**
 * @see [ClientUserDefineRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientUserDefineRule].
 */
public suspend fun clientUserDefineRule(
    name: String,
    block: suspend ClientUserDefineRuleResourceBuilder.() -> Unit,
): ClientUserDefineRule {
    val builder = ClientUserDefineRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientUserDefineRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientUserDefineRule(name: String): ClientUserDefineRule {
    val builder = ClientUserDefineRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
