@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Client User Define Rule resource. Malicious Behavior Defense Custom Rules.
 * For information about Threat Detection Client User Define Rule and how to use it, see [What is Client User Define Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-addclientuserdefinerule).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ClientUserDefineRule("default", {
 *     actionType: 0,
 *     platform: "windows",
 *     registryContent: "123",
 *     clientUserDefineRuleName: name,
 *     parentProcPath: "/root/bash",
 *     type: 5,
 *     cmdline: "bash",
 *     procPath: "/root/bash",
 *     parentCmdline: "bash",
 *     registryKey: "123",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ClientUserDefineRule("default",
 *     action_type=0,
 *     platform="windows",
 *     registry_content="123",
 *     client_user_define_rule_name=name,
 *     parent_proc_path="/root/bash",
 *     type=5,
 *     cmdline="bash",
 *     proc_path="/root/bash",
 *     parent_cmdline="bash",
 *     registry_key="123")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ClientUserDefineRule("default", new()
 *     {
 *         ActionType = 0,
 *         Platform = "windows",
 *         RegistryContent = "123",
 *         ClientUserDefineRuleName = name,
 *         ParentProcPath = "/root/bash",
 *         Type = 5,
 *         Cmdline = "bash",
 *         ProcPath = "/root/bash",
 *         ParentCmdline = "bash",
 *         RegistryKey = "123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewClientUserDefineRule(ctx, "default", &threatdetection.ClientUserDefineRuleArgs{
 * 			ActionType:               pulumi.Int(0),
 * 			Platform:                 pulumi.String("windows"),
 * 			RegistryContent:          pulumi.String("123"),
 * 			ClientUserDefineRuleName: pulumi.String(name),
 * 			ParentProcPath:           pulumi.String("/root/bash"),
 * 			Type:                     pulumi.Int(5),
 * 			Cmdline:                  pulumi.String("bash"),
 * 			ProcPath:                 pulumi.String("/root/bash"),
 * 			ParentCmdline:            pulumi.String("bash"),
 * 			RegistryKey:              pulumi.String("123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ClientUserDefineRule;
 * import com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ClientUserDefineRule("default", ClientUserDefineRuleArgs.builder()
 *             .actionType("0")
 *             .platform("windows")
 *             .registryContent("123")
 *             .clientUserDefineRuleName(name)
 *             .parentProcPath("/root/bash")
 *             .type("5")
 *             .cmdline("bash")
 *             .procPath("/root/bash")
 *             .parentCmdline("bash")
 *             .registryKey("123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ClientUserDefineRule
 *     properties:
 *       actionType: '0'
 *       platform: windows
 *       registryContent: '123'
 *       clientUserDefineRuleName: ${name}
 *       parentProcPath: /root/bash
 *       type: '5'
 *       cmdline: bash
 *       procPath: /root/bash
 *       parentCmdline: bash
 *       registryKey: '123'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Client User Define Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/clientUserDefineRule:ClientUserDefineRule example <id>
 * ```
 * @property actionType The operation type. Value:
 * - **0**: plus White
 * - **1**: Plus Black.
 * @property clientUserDefineRuleName The custom rule name.
 * @property cmdline Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
 * @property filePath The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
 * @property hash Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
 * @property ip IP address. When the value of the Type attribute is 3, the Ip attribute is required.
 * @property newFilePath The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
 * @property parentCmdline The parent command line.
 * @property parentProcPath Parent process path.
 * @property platform The operating system type. Value:
 * - **windows**:widows
 * - **linux**:linux
 * - **all**: all.
 * @property portStr The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
 * @property procPath The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
 * @property registryContent The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
 * @property registryKey The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
 * @property type The rule type. Value:
 * - **1**: Process hash
 * - **2**: command line
 * - **3**: Process network
 * - **4**: File reading and writing
 * - **5**: Operate the registry
 * - **6**: Load Dynamic Link Library
 * - **7**: File Rename.
 */
public data class ClientUserDefineRuleArgs(
    public val actionType: Output<Int>? = null,
    public val clientUserDefineRuleName: Output<String>? = null,
    public val cmdline: Output<String>? = null,
    public val filePath: Output<String>? = null,
    public val hash: Output<String>? = null,
    public val ip: Output<String>? = null,
    public val newFilePath: Output<String>? = null,
    public val parentCmdline: Output<String>? = null,
    public val parentProcPath: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val portStr: Output<String>? = null,
    public val procPath: Output<String>? = null,
    public val registryContent: Output<String>? = null,
    public val registryKey: Output<String>? = null,
    public val type: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs =
        com.pulumi.alicloud.threatdetection.ClientUserDefineRuleArgs.builder()
            .actionType(actionType?.applyValue({ args0 -> args0 }))
            .clientUserDefineRuleName(clientUserDefineRuleName?.applyValue({ args0 -> args0 }))
            .cmdline(cmdline?.applyValue({ args0 -> args0 }))
            .filePath(filePath?.applyValue({ args0 -> args0 }))
            .hash(hash?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 }))
            .newFilePath(newFilePath?.applyValue({ args0 -> args0 }))
            .parentCmdline(parentCmdline?.applyValue({ args0 -> args0 }))
            .parentProcPath(parentProcPath?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .portStr(portStr?.applyValue({ args0 -> args0 }))
            .procPath(procPath?.applyValue({ args0 -> args0 }))
            .registryContent(registryContent?.applyValue({ args0 -> args0 }))
            .registryKey(registryKey?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientUserDefineRuleArgs].
 */
@PulumiTagMarker
public class ClientUserDefineRuleArgsBuilder internal constructor() {
    private var actionType: Output<Int>? = null

    private var clientUserDefineRuleName: Output<String>? = null

    private var cmdline: Output<String>? = null

    private var filePath: Output<String>? = null

    private var hash: Output<String>? = null

    private var ip: Output<String>? = null

    private var newFilePath: Output<String>? = null

    private var parentCmdline: Output<String>? = null

    private var parentProcPath: Output<String>? = null

    private var platform: Output<String>? = null

    private var portStr: Output<String>? = null

    private var procPath: Output<String>? = null

    private var registryContent: Output<String>? = null

    private var registryKey: Output<String>? = null

    private var type: Output<Int>? = null

    /**
     * @param value The operation type. Value:
     * - **0**: plus White
     * - **1**: Plus Black.
     */
    @JvmName("rsbcvbnwunmjndeg")
    public suspend fun actionType(`value`: Output<Int>) {
        this.actionType = value
    }

    /**
     * @param value The custom rule name.
     */
    @JvmName("twveavoiaximaofk")
    public suspend fun clientUserDefineRuleName(`value`: Output<String>) {
        this.clientUserDefineRuleName = value
    }

    /**
     * @param value Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
     */
    @JvmName("cekoqgwkvohflvwc")
    public suspend fun cmdline(`value`: Output<String>) {
        this.cmdline = value
    }

    /**
     * @param value The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
     */
    @JvmName("tfqvqgcykcvpcxhx")
    public suspend fun filePath(`value`: Output<String>) {
        this.filePath = value
    }

    /**
     * @param value Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
     */
    @JvmName("omogyoqjgaebuirl")
    public suspend fun hash(`value`: Output<String>) {
        this.hash = value
    }

    /**
     * @param value IP address. When the value of the Type attribute is 3, the Ip attribute is required.
     */
    @JvmName("sndmacbeiaffiixl")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
     */
    @JvmName("qkfvadvryouyrqrn")
    public suspend fun newFilePath(`value`: Output<String>) {
        this.newFilePath = value
    }

    /**
     * @param value The parent command line.
     */
    @JvmName("ieugulmclkokfvck")
    public suspend fun parentCmdline(`value`: Output<String>) {
        this.parentCmdline = value
    }

    /**
     * @param value Parent process path.
     */
    @JvmName("gnrcpajhwqmpeoej")
    public suspend fun parentProcPath(`value`: Output<String>) {
        this.parentProcPath = value
    }

    /**
     * @param value The operating system type. Value:
     * - **windows**:widows
     * - **linux**:linux
     * - **all**: all.
     */
    @JvmName("rulxetdpcookocbw")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
     */
    @JvmName("hhxgyvpcbtieswjn")
    public suspend fun portStr(`value`: Output<String>) {
        this.portStr = value
    }

    /**
     * @param value The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
     */
    @JvmName("vlsdprohhlxhksdx")
    public suspend fun procPath(`value`: Output<String>) {
        this.procPath = value
    }

    /**
     * @param value The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    @JvmName("xbhinpkbcnjsgeoo")
    public suspend fun registryContent(`value`: Output<String>) {
        this.registryContent = value
    }

    /**
     * @param value The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    @JvmName("unsdaugpunbnrtdp")
    public suspend fun registryKey(`value`: Output<String>) {
        this.registryKey = value
    }

    /**
     * @param value The rule type. Value:
     * - **1**: Process hash
     * - **2**: command line
     * - **3**: Process network
     * - **4**: File reading and writing
     * - **5**: Operate the registry
     * - **6**: Load Dynamic Link Library
     * - **7**: File Rename.
     */
    @JvmName("mghlslwtpeqwggjd")
    public suspend fun type(`value`: Output<Int>) {
        this.type = value
    }

    /**
     * @param value The operation type. Value:
     * - **0**: plus White
     * - **1**: Plus Black.
     */
    @JvmName("vssxsrtoameclncj")
    public suspend fun actionType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The custom rule name.
     */
    @JvmName("cqnsigdmdlogmfkv")
    public suspend fun clientUserDefineRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientUserDefineRuleName = mapped
    }

    /**
     * @param value Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
     */
    @JvmName("xtbtxqwocwftlpwy")
    public suspend fun cmdline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmdline = mapped
    }

    /**
     * @param value The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
     */
    @JvmName("demowaqwdqopqwrp")
    public suspend fun filePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePath = mapped
    }

    /**
     * @param value Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
     */
    @JvmName("fhgbfwcknqxqwpfl")
    public suspend fun hash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hash = mapped
    }

    /**
     * @param value IP address. When the value of the Type attribute is 3, the Ip attribute is required.
     */
    @JvmName("ejlryesbpldljlbf")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
     */
    @JvmName("soldkeuybhsawwie")
    public suspend fun newFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newFilePath = mapped
    }

    /**
     * @param value The parent command line.
     */
    @JvmName("hinctbvgibkklwtp")
    public suspend fun parentCmdline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentCmdline = mapped
    }

    /**
     * @param value Parent process path.
     */
    @JvmName("jnktydumultwbxfh")
    public suspend fun parentProcPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentProcPath = mapped
    }

    /**
     * @param value The operating system type. Value:
     * - **windows**:widows
     * - **linux**:linux
     * - **all**: all.
     */
    @JvmName("feuqngqcfuggdavn")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
     */
    @JvmName("xixoxxvqgujyyxqk")
    public suspend fun portStr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portStr = mapped
    }

    /**
     * @param value The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
     */
    @JvmName("wsumsknsardjmcqm")
    public suspend fun procPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.procPath = mapped
    }

    /**
     * @param value The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    @JvmName("plumxbaoyhvrsnve")
    public suspend fun registryContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryContent = mapped
    }

    /**
     * @param value The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
     */
    @JvmName("qtwnnxmpsqvhbjar")
    public suspend fun registryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryKey = mapped
    }

    /**
     * @param value The rule type. Value:
     * - **1**: Process hash
     * - **2**: command line
     * - **3**: Process network
     * - **4**: File reading and writing
     * - **5**: Operate the registry
     * - **6**: Load Dynamic Link Library
     * - **7**: File Rename.
     */
    @JvmName("orjvbkhijjfylhxe")
    public suspend fun type(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ClientUserDefineRuleArgs = ClientUserDefineRuleArgs(
        actionType = actionType,
        clientUserDefineRuleName = clientUserDefineRuleName,
        cmdline = cmdline,
        filePath = filePath,
        hash = hash,
        ip = ip,
        newFilePath = newFilePath,
        parentCmdline = parentCmdline,
        parentProcPath = parentProcPath,
        platform = platform,
        portStr = portStr,
        procPath = procPath,
        registryContent = registryContent,
        registryKey = registryKey,
        type = type,
    )
}
