@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FileUploadLimit].
 */
@PulumiTagMarker
public class FileUploadLimitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileUploadLimitArgs = FileUploadLimitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileUploadLimitArgsBuilder.() -> Unit) {
        val builder = FileUploadLimitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileUploadLimit {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.FileUploadLimit(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FileUploadLimit(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Threat Detection File Upload Limit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/fileUploadLimit:FileUploadLimit example
 * ```
 */
public class FileUploadLimit internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.FileUploadLimit,
) : KotlinCustomResource(javaResource, FileUploadLimitMapper) {
    /**
     * File Upload Threshold.
     */
    public val limit: Output<Int>
        get() = javaResource.limit().applyValue({ args0 -> args0 })
}

public object FileUploadLimitMapper : ResourceMapper<FileUploadLimit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.FileUploadLimit::class == javaResource::class

    override fun map(javaResource: Resource): FileUploadLimit = FileUploadLimit(
        javaResource as
            com.pulumi.alicloud.threatdetection.FileUploadLimit,
    )
}

/**
 * @see [FileUploadLimit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileUploadLimit].
 */
public suspend fun fileUploadLimit(
    name: String,
    block: suspend FileUploadLimitResourceBuilder.() -> Unit,
): FileUploadLimit {
    val builder = FileUploadLimitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileUploadLimit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileUploadLimit(name: String): FileUploadLimit {
    val builder = FileUploadLimitResourceBuilder()
    builder.name(name)
    return builder.build()
}
