@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.FileUploadLimitArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Threat Detection File Upload Limit can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/fileUploadLimit:FileUploadLimit example
 * ```
 * @property limit File Upload Threshold.
 */
public data class FileUploadLimitArgs(
    public val limit: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.FileUploadLimitArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.FileUploadLimitArgs =
        com.pulumi.alicloud.threatdetection.FileUploadLimitArgs.builder()
            .limit(limit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileUploadLimitArgs].
 */
@PulumiTagMarker
public class FileUploadLimitArgsBuilder internal constructor() {
    private var limit: Output<Int>? = null

    /**
     * @param value File Upload Threshold.
     */
    @JvmName("viskupkwjlwsqsll")
    public suspend fun limit(`value`: Output<Int>) {
        this.limit = value
    }

    /**
     * @param value File Upload Threshold.
     */
    @JvmName("kkhmqhfnyxpprauf")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limit = mapped
    }

    internal fun build(): FileUploadLimitArgs = FileUploadLimitArgs(
        limit = limit,
    )
}
